package ru.yandex.travel.cpa.data_processing.flow.model.labels;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import lombok.Data;

@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class LabelFieldsAvia {

    @JsonProperty("unixtime")
    private long timestamp;

    @JsonProperty("marker")
    private String label;

    @JsonProperty("national_version")
    private String nationalVersion;

    @JsonProperty("pp")
    private long pp;

    @JsonProperty("price")
    private double price;

    @JsonProperty("when")
    private String when;

    @JsonProperty("return_date")
    private String returnDate;

    @JsonProperty("adult_seats")
    private long adultSeats;

    @JsonProperty("children_seats")
    private long childrenSeats;

    @JsonProperty("infant_seats")
    private long infantSeats;

    @JsonProperty("offer_price")
    private double offerPrice;

    @JsonProperty("utm_source")
    private String utmSource;

    @JsonProperty("utm_medium")
    private String utmMedium;

    @JsonProperty("utm_campaign")
    private String utmCampaign;

    @JsonProperty("utm_content")
    private String utmContent;

    @JsonProperty("utm_term")
    private String utmTerm;

    @JsonProperty("wizardRedirKey")
    private String wizardRedirKey;

    @JsonProperty("offer_currency")
    private String offerCurrency;

    // Using JsonNode is workaround for field type issue. To be removed after TRAVELFRONT-7800 resolving
    @JsonProperty("ytp_referer")
    private JsonNode ytpReferer;

    @JsonProperty("yandexuid")
    private String yandexUid;

    @JsonProperty("passportuid")
    private String passportId;

    @JsonProperty("klass")
    private String serviceClass;

    @JsonProperty("affiliateClid")
    private String affiliateClid;

    @JsonProperty("admitadUid")
    private String admitadUid;

    @JsonProperty("travelpayoutsUid")
    private String travelpayoutsUid;

    @JsonProperty("vid")
    private String vid;

    @JsonProperty("affiliateVid")
    private String affiliateVid;

    @JsonProperty("fromId")
    private String fromId;

    @JsonProperty("toId")
    private String toId;
}
