package ru.yandex.travel.cpa.data_processing.flow.model.labels;

import java.io.IOException;
import java.util.Base64;

import com.fasterxml.jackson.databind.ObjectMapper;

import ru.yandex.travel.avia.proto.cpa.TLabel;
import ru.yandex.travel.cpa.data_processing.flow.model.AbstractMessageDecoder;

public class LabelJsonDecoderAvia extends AbstractMessageDecoder<Label> {
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    protected Label decodeItem(String data) throws IOException {
        var fields = mapper.readValue(data, LabelFieldsAvia.class);
        var labelMessageBuilder = TLabel
                .newBuilder()
                .setAdultSeats(fields.getAdultSeats())
                .setChildrenSeats(fields.getChildrenSeats())
                .setInfantSeats(fields.getInfantSeats())
                .setNationalVersion(fields.getNationalVersion())
                .setOfferCurrency(fields.getOfferCurrency())
                .setOfferPrice(fields.getOfferPrice())
                .setPp(fields.getPp())
                .setPrice(fields.getPrice())
                .setReturnDate(fields.getReturnDate())
                .setWhen(fields.getWhen())
                .setServiceClass(fields.getServiceClass());
        if (fields.getUtmCampaign() != null) {
            labelMessageBuilder.setUtmCampaign(fields.getUtmCampaign());
        }
        if (fields.getUtmContent() != null) {
            labelMessageBuilder.setUtmContent(fields.getUtmContent());
        }
        if (fields.getUtmMedium() != null) {
            labelMessageBuilder.setUtmMedium(fields.getUtmMedium());
        }
        if (fields.getUtmSource() != null) {
            labelMessageBuilder.setUtmSource(fields.getUtmSource());
        }
        if (fields.getUtmTerm() != null) {
            labelMessageBuilder.setUtmTerm(fields.getUtmTerm());
        }
        if (fields.getWizardRedirKey() != null) {
            labelMessageBuilder.setWizardredirkey(fields.getWizardRedirKey());
        }
        if (fields.getYtpReferer() != null && fields.getYtpReferer().isTextual()) {
            labelMessageBuilder.setYtpReferer(fields.getYtpReferer().textValue());
        }
        if (fields.getYandexUid() != null) {
            labelMessageBuilder.setYandexUid(fields.getYandexUid());
        }
        if (fields.getPassportId() != null) {
            labelMessageBuilder.setPassportId(fields.getPassportId());
        }
        if (fields.getAffiliateClid() != null) {
            labelMessageBuilder.setAffiliateClid(fields.getAffiliateClid());
        }
        if (fields.getAdmitadUid() != null) {
            labelMessageBuilder.setAdmitadUid(fields.getAdmitadUid());
        }
        if (fields.getTravelpayoutsUid() != null) {
            labelMessageBuilder.setTravelpayoutsUid(fields.getTravelpayoutsUid());
        }
        if (fields.getVid() != null) {
            labelMessageBuilder.setVid(fields.getVid());
        }
        if (fields.getAffiliateVid() != null) {
            labelMessageBuilder.setAffiliateVid(fields.getAffiliateVid());
        }
        if (fields.getFromId() != null) {
            labelMessageBuilder.setFromId(fields.getFromId());
        }
        if (fields.getToId() != null) {
            labelMessageBuilder.setToId(fields.getToId());
        }
        var labelData = Base64.getEncoder().encode(labelMessageBuilder.build().toByteArray());
        return new Label(
                "avia",
                fields.getTimestamp(),
                fields.getLabel(),
                labelData
        );
    }
}
