package ru.yandex.travel.cpa.data_processing.flow.model.labels;

import java.io.IOException;

import com.fasterxml.jackson.databind.ObjectMapper;

import ru.yandex.travel.cpa.data_processing.flow.model.AbstractMessageDecoder;

public class LabelJsonDecoderTrain extends AbstractMessageDecoder<Label> {
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    protected Label decodeItem(String data) throws IOException {
        var fields = mapper.readValue(data, LabelFieldsTrain.class);
        return new Label(
                "train",
                fields.getTimestamp(),
                fields.getLabel(),
                fields.getData().getBytes()
        );
    }
}
