package ru.yandex.travel.cpa.data_processing.flow.model.orders;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.travel.cpa.data_processing.flow.yt.YtMessageConverter;
import ru.yandex.yt.ytclient.tables.ColumnValueType;
import ru.yandex.yt.ytclient.tables.TableSchema;
import ru.yandex.yt.ytclient.wire.UnversionedValue;

public class OrderPurgatoryConverter implements YtMessageConverter<OrderPurgatoryKey, OrderPurgatoryValue> {
    private final static int LABEL_COL = 0;
    private final static int PARTNER_NAME_COL = 1;
    private final static int PARTNER_ORDER_ID_COL = 2;
    private final static int UPDATED_AT_COL = 3;

    @Override
    public TableSchema getTableSchema() {
        return new TableSchema.Builder()
                .addKey("label", ColumnValueType.STRING)
                .addKey("partner_name", ColumnValueType.STRING)
                .addKey("partner_order_id", ColumnValueType.STRING)
                .addValue("updated_at", ColumnValueType.STRING)
                .build();
    }

    @Override
    public Map<String, Serializable> serialize(OrderPurgatoryValue object) {
        var serialized = new HashMap<String, Serializable>();
        serialized.put("label", object.getLabel());
        serialized.put("partner_name", object.getPartner_name());
        serialized.put("partner_order_id", object.getPartner_order_id());
        serialized.put("updated_at", object.getUpdated_at());
        return serialized;
    }

    @Override
    public OrderPurgatoryValue deserialize(List<UnversionedValue> row) {
        return new OrderPurgatoryValue(
                row.get(LABEL_COL).stringValue(),
                row.get(PARTNER_NAME_COL).stringValue(),
                row.get(PARTNER_ORDER_ID_COL).stringValue(),
                row.get(UPDATED_AT_COL).longValue()
        );
    }

    @Override
    public List<String> getLookupColumns() {
        return List.of("label", "partner_name", "partner_order_id", "updated_at");
    }

    @Override
    public List<Object> getFilterValues(OrderPurgatoryValue message) {
        return List.of(message.getLabel());
    }

    @Override
    public List<String> getSelectColumns() {
        return List.of("label");
    }

    @Override
    public String getSelectValues(OrderPurgatoryKey key) {
        return String.format("('%s')", key.getLabel());
    }
}
