package ru.yandex.travel.cpa.data_processing.flow.model.orders;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.travel.cpa.data_processing.flow.yt.YtMessageConverter;
import ru.yandex.yt.ytclient.tables.ColumnValueType;
import ru.yandex.yt.ytclient.tables.TableSchema;
import ru.yandex.yt.ytclient.wire.UnversionedValue;

public class OrderQueueConverter implements YtMessageConverter<OrderKey, OrderKey> {
    private final static int PARTNER_NAME_COL = 0;
    private final static int PARTNER_ORDER_ID_COL = 1;

    @Override
    public TableSchema getTableSchema() {
        return new TableSchema.Builder()
                .setUniqueKeys(false)
                .addValue("partner_name", ColumnValueType.STRING)
                .addValue("partner_order_id", ColumnValueType.STRING)
                .build();
    }

    @Override
    public Map<String, Serializable> serialize(OrderKey object) {
        var serialized = new HashMap<String, Serializable>();
        serialized.put("partner_name", object.getPartnerName());
        serialized.put("partner_order_id", object.getPartnerOrderId());
        return serialized;
    }

    // column order should match one at getLookupColumns
    @Override
    public OrderKey deserialize(List<UnversionedValue> row) {
        return new OrderKey(
                row.get(PARTNER_NAME_COL).stringValue(),
                row.get(PARTNER_ORDER_ID_COL).stringValue()
        );
    }

    // column order should match one at deserialize
    @Override
    public List<String> getLookupColumns() {
        return List.of("partner_name", "partner_order_id");
    }

    @Override
    public List<Object> getFilterValues(OrderKey message) {
        return List.of(message.getPartnerName(), message.getPartnerOrderId());
    }

    @Override
    public List<String> getSelectColumns() {
        return List.of("partner_name", "partner_order_id");
    }

    @Override
    public String getSelectValues(OrderKey key) {
        return String.format("('%s', '%s')", key.getPartnerName(), key.getPartnerOrderId());
    }
}
