package ru.yandex.travel.cpa.data_processing.flow.model.snapshots;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.travel.cpa.data_processing.flow.model.orders.OrderKey;
import ru.yandex.travel.cpa.data_processing.flow.yt.YtMessageConverter;
import ru.yandex.yt.ytclient.tables.ColumnValueType;
import ru.yandex.yt.ytclient.tables.TableSchema;
import ru.yandex.yt.ytclient.wire.UnversionedValue;

public class ProcessedSnapshotsConverter implements YtMessageConverter<OrderKey, Snapshot> {
    @Override
    public TableSchema getTableSchema() {
        return new TableSchema.Builder()
                .addKey("partner_name", ColumnValueType.STRING)
                .addKey("partner_order_id", ColumnValueType.STRING)
                .addValue("hash", ColumnValueType.STRING)
                .addValue("updated_at", ColumnValueType.UINT64)
                .build();
    }

    @Override
    public Map<String, Serializable> serialize(Snapshot object) {
        var serialized = new HashMap<String, Serializable>();
        serialized.put("partner_name", object.getPartnerName());
        serialized.put("partner_order_id", object.getPartnerOrderId());
        serialized.put("hash", object.getHash());
        serialized.put("updated_at", object.getUpdatedAt());
        return serialized;
    }

    @Override
    public Snapshot deserialize(List<UnversionedValue> row) {
        return new Snapshot(
                row.get(0).stringValue(),
                row.get(1).stringValue(),
                row.get(2).stringValue(),
                row.get(3).longValue(),
                null
        );
    }

    @Override
    public List<String> getLookupColumns() {
        return List.of("partner_name", "partner_order_id", "hash", "updated_at");
    }

    @Override
    public List<Object> getFilterValues(Snapshot message) {
        return List.of(message.getPartnerName(), message.getPartnerOrderId());
    }

    @Override
    public List<String> getSelectColumns() {
        return List.of("partner_name", "partner_order_id");
    }

    @Override
    public String getSelectValues(OrderKey key) {
        return String.format("('%s', '%s')", key.getPartnerName(), key.getPartnerOrderId());
    }
}
