package ru.yandex.travel.cpa.data_processing.flow.model.snapshots;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.travel.cpa.data_processing.flow.model.orders.OrderKey;
import ru.yandex.travel.cpa.data_processing.flow.yt.YtMessageConverter;
import ru.yandex.yt.ytclient.tables.ColumnValueType;
import ru.yandex.yt.ytclient.tables.TableSchema;
import ru.yandex.yt.ytclient.wire.UnversionedValue;

public class SnapshotErrorsConverter implements YtMessageConverter<OrderKey, SnapshotError> {
    private final static int PARTNER_NAME_COL = 0;
    private final static int PARTNER_ORDER_ID_COL = 1;
    private final static int UPDATED_AT_COL = 2;
    private final static int ERROR_COL = 3;

    @Override
    public TableSchema getTableSchema() {
        return new TableSchema.Builder()
                .setUniqueKeys(false)
                .addValue("partner_name", ColumnValueType.STRING)
                .addValue("partner_order_id", ColumnValueType.STRING)
                .addValue("updated_at", ColumnValueType.UINT64)
                .addValue("error", ColumnValueType.STRING)
                .build();
    }

    @Override
    public Map<String, Serializable> serialize(SnapshotError object) {
        var serialized = new HashMap<String, Serializable>();
        serialized.put("partner_name", object.getPartnerName());
        serialized.put("partner_order_id", object.getPartnerOrderId());
        serialized.put("updated_at", object.getUpdatedAt());
        serialized.put("error", object.getError());
        return serialized;
    }

    @Override
    public SnapshotError deserialize(List<UnversionedValue> row) {
        return new SnapshotError(
                row.get(PARTNER_NAME_COL).stringValue(),
                row.get(PARTNER_ORDER_ID_COL).stringValue(),
                row.get(UPDATED_AT_COL).longValue(),
                row.get(ERROR_COL).stringValue()
        );
    }

    @Override
    public List<String> getLookupColumns() {
        return List.of("partner_name", "partner_order_id", "updated_at", "error");
    }

    @Override
    public List<Object> getFilterValues(SnapshotError message) {
        return List.of(message.getPartnerName(), message.getPartnerOrderId());
    }

    @Override
    public List<String> getSelectColumns() {
        return List.of("partner_name", "partner_order_id");
    }

    @Override
    public String getSelectValues(OrderKey key) {
        return String.format("('%s', '%s')", key.getPartnerName(), key.getPartnerOrderId());
    }
}
