package ru.yandex.travel.cpa.data_processing.flow.model.snapshots;

import java.io.IOException;
import java.util.Collections;
import java.util.List;

import com.fasterxml.jackson.databind.ObjectMapper;

import ru.yandex.travel.cpa.data_processing.flow.model.MessageDecoder;

public class SnapshotJsonDecoder implements MessageDecoder<Snapshot> {

    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public List<Snapshot> decode(byte[] data) throws IOException {
        return Collections.singletonList(new Snapshot(mapper.readValue(data, SnapshotFields.class), data));
    }
}
