package ru.yandex.travel.cpa.data_processing.flow.yt;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

import ru.yandex.yt.ytclient.tables.TableSchema;
import ru.yandex.yt.ytclient.wire.UnversionedValue;

public interface YtMessageConverter<K, V> {
    TableSchema getTableSchema();
    Map<String, Serializable> serialize(V object);
    V deserialize(List<UnversionedValue> row) throws IOException;  // column order should match one at getLookupColumns
    List<String> getLookupColumns();  // column order should match one at deserialize
    List<Object> getFilterValues(V message);
    List<String> getSelectColumns();
    String getSelectValues(K key);
}
