RECURSE(
    src/test
)

JAVA_PROGRAM(travel-cpa-flow)

JDK_VERSION(11)

INCLUDE(${ARCADIA_ROOT}/travel/library/java/dependencies.inc)
INCLUDE(${ARCADIA_ROOT}/travel/library/java/lombok.inc)

OWNER(g:travel-hotels)

JAVA_SRCS(SRCDIR src/main/java **/*)
JAVA_SRCS(SRCDIR src/main/resources **/*)

WITH_KOTLIN()

PEERDIR(
    contrib/java/org/apache/logging/log4j/log4j-jcl
    contrib/java/org/springframework/retry/spring-retry
    kikimr/persqueue/sdk/java/v0
    travel/proto/avia/cpa
    travel/library/java/spring-boot-skeleton
    yt/java/ytclient
)

GENERATE_SCRIPT(
    TEMPLATE ${ARCADIA_ROOT}/travel/hotels/devops/starter/starter.template.py
    OUT ${BINDIR}/bin/flow.py
    CUSTOM_PROPERTY appName travel-cpa-flow
    CUSTOM_PROPERTY mainClass ru.yandex.travel.cpa.data_processing.flow.FlowApplication
)

# Added automatically to remove dependency on default contrib versions
DEPENDENCY_MANAGEMENT(
    contrib/java/org/springframework/retry/spring-retry/1.2.5.RELEASE
)

LINT(base)
END()
