# -*- coding: utf-8 -*-

from typing import Any, Callable, Iterable, Optional


def batch_iterator(items: Iterable[Any], batch_size: int, func: Optional[Callable[[Any], Any]]) -> list[Any]:
    buffer = list()
    for item in items:
        if func:
            item = func(item)
        buffer.append(item)
        if len(buffer) == batch_size:
            yield buffer
            buffer = list()
    if buffer:
        yield buffer
