import base64
import logging
from datetime import datetime

from travel.cpa.lib.common import with_retries
from travel.cpa.lib.lb_writer import LBWriter
from travel.proto.cpa import order_info_pb2 as order_info_pb2


class OrderNotifier:

    def __init__(self, url: str, port: int, topic: str, source_id: str, token: str):
        self.topic = topic
        self.lb_writer = LBWriter(url, port, source_id.encode(), token)

    def notify(self, messages: list[order_info_pb2.TGenericOrderInfo]) -> None:
        logging.info(f'Sending notification on {len(messages)} order(s) change')
        data = list()
        for message in messages:
            message_bytes = message.SerializeToString()
            encoded = base64.urlsafe_b64encode(message_bytes).decode()
            item = {
                '_timestamp': int(datetime.utcnow().timestamp()),
                'message_type': message.DESCRIPTOR.name,
                'proto': encoded,
            }
            data.append(item)
        with_retries(self.lb_writer.write)(self.topic, [data])
        logging.info('Notification sent')
