# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from abc import abstractmethod
from functools import wraps

from six import binary_type

from travel.cpa.lib.lib_logging import get_logger


LOG = get_logger(__name__)

HIDDEN_OPTIONS = ['auth', 'password', 'secret', 'token']


def hide_secrets(d):
    result = dict()
    for key, value in d.items():
        for option in HIDDEN_OPTIONS:
            value = '*******' if option in key else value
        result[key] = value
    return result


def json_bytes_to_unicode(j):
    if isinstance(j, dict):
        return {json_bytes_to_unicode(k): json_bytes_to_unicode(v) for k, v in j.items()}

    if isinstance(j, list):
        return [json_bytes_to_unicode(v) for v in j]

    return j.decode('utf8') if isinstance(j, binary_type) else j


def with_retries(func=None, max_attempts=3, exc_info=True, counter=None, key=None):
    if not func:
        return lambda f: with_retries(f, max_attempts=max_attempts, exc_info=exc_info, counter=counter, key=key)

    @wraps(func)
    def wrapper(*args, **kwargs):
        attempts = max_attempts
        while True:
            try:
                return func(*args, **kwargs)
            except Exception as e:
                if counter is not None and key is not None:
                    counter[key] += 1
                attempts -= 1
                if attempts == 0:
                    raise
                LOG.warn('%r failed, %d attempts left', func, attempts)
                if exc_info:
                    LOG.warn(e)

    return wrapper


@property
@abstractmethod
def abstract_attribute(self):
    pass
