# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from datetime import date, datetime

from dateutil.relativedelta import relativedelta
from parse import parse
from six import text_type


def iter_day(date_from, date_to):
    while date_from <= date_to:
        yield date_from
        date_from += relativedelta(days=+1)


def iter_day_from(date_from):
    return iter_day(date_from, date.today())


def iter_day_reversed(date_from, date_to):
    while date_from >= date_to:
        yield date_from
        date_from += relativedelta(days=-1)


def iter_day_to_reversed(date_to):
    return iter_day_reversed(date.today(), date_to)


def iter_month(date_from, date_to):
    date_from = date_from.replace(day=1)
    while date_from <= date_to:
        yield date_from
        date_from += relativedelta(months=+1)


def iter_month_from(date_from):
    return iter_month(date_from, date.today())


def iter_periods(date_from, date_to, max_period_days):
    while date_from < date_to:
        next_date_from = min(date_from + relativedelta(days=max_period_days), date_to)
        yield (date_from, next_date_from)
        date_from = next_date_from


def parse_datetime_iso(dt_text):
    return parse('{:ti}', dt_text)[0]


def timestamp(dt):
    return int((dt - datetime(1970, 1, 1, tzinfo=dt.tzinfo)).total_seconds())


def timestamp_to_str(ts):
    return text_type(datetime.fromtimestamp(ts))
