# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from logging import getLogger


LOG_CONFIG = {
    'version': 1,
    'disable_existing_loggers': False,
    'handlers': {
        'stdout': {
            'class': 'logging.StreamHandler',
            'formatter': 'default',
            'stream': 'ext://sys.stdout',
        },
    },
    'formatters': {
        'default': {
            'format': '%(asctime)s %(levelname)-8s %(name)-20s %(message)s',
            'datefmt': '%Y-%m-%d %H:%M:%S',
        },
    },
    'loggers': {
        '': {
            'handlers': ['stdout'],
            'level': 'DEBUG',
        },
        'http': {
            'level': 'WARNING',
        },
        'ydb.resolver.DiscoveryEndpointsResolver': {
            'level': 'WARNING',
        },
        'ydb.connection': {
            'level': 'WARNING',
        },
        'kikimr.public.sdk.python.persqueue._core': {
            'level': 'WARNING',
        },
        'kikimr.public.sdk.python.persqueue._grpc': {
            'level': 'WARNING',
        },
        'kikimr.public.sdk.python.persqueue._util': {
            'level': 'WARNING',
        },
        'parse': {
            'level': 'WARNING',
        },
        'statface_client': {
            'level': 'WARNING',
        },
        'urllib3.connectionpool': {
            'level': 'WARNING',
        },
        'yt.packages.urllib3.connectionpool': {
            'level': 'WARNING',
        },
        'yql.client.request': {
            'level': 'WARNING',
        },
    },
}


def get_logger(name):
    parts = name.split('.')
    return getLogger('.'.join(parts[2:]) if len(parts) > 2 else name)
