# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from argparse import ArgumentParser

from travel.cpa.tools import build_proxy_config
from travel.cpa.tools import build_schema
from travel.cpa.tools import get_status_mappings


def main():
    parser = ArgumentParser()
    subparsers = parser.add_subparsers()

    subparser = subparsers.add_parser('proxy_config')
    subparser.set_defaults(func=build_proxy_config.run)

    default_output_fn = '~/arcadia/travel/cpa/devops/ipv4-proxy/docker/nginx/50-proxy.conf'
    subparser.add_argument('--output-fn', default=default_output_fn)

    subparser = subparsers.add_parser('lf_schema')
    subparser.set_defaults(func=build_schema.run)
    subparser.add_argument('fn', nargs='?', default='travel-cpa-collectors-result.json', help='file to save schema')

    subparser = subparsers.add_parser('status_mappings')
    subparser.set_defaults(func=get_status_mappings.run)

    args = parser.parse_args()
    args.func(args)


if __name__ == '__main__':
    main()
