# -*- coding: utf-8 -*-
from __future__ import print_function, unicode_literals

from collections import OrderedDict
import json

from travel.cpa.lib.order_snapshot import PROVIDERS


def run(args):
    common_schema = OrderedDict()
    for provider in PROVIDERS:
        common_schema.update(provider().get_logfeller_schema())
    fields = [{'name': n, 'type': t} for n, t in common_schema.items()]
    schema = {'fields': fields}
    with open(args.fn, 'wb') as f:
        json.dump(schema, f, indent=4, separators=(',', ': '))
