# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from argparse import ArgumentParser
import logging

from travel.cpa.tools3 import prepare_tables, rebuild_orders, switch_mode
from travel.library.python.yandex_vault import resolve_secrets_ns


def main():
    logging.basicConfig(level=logging.INFO, format='%(asctime)s %(message)s')

    parser = ArgumentParser()

    parser.add_argument('--vault-token')

    subparsers = parser.add_subparsers()

    subparser = subparsers.add_parser('prepare_tables')
    subparser.set_defaults(func=prepare_tables.run)
    subparser.add_argument('--yt-token', required=True)
    subparser.add_argument('--yt-proxies', nargs='*', default=['arnold', 'hahn'])
    subparser.add_argument('--env', choices=['prod', 'testing', 'dev'], required=True)
    subparser.add_argument('--user')

    subparser = subparsers.add_parser('rebuild_orders')
    subparser.set_defaults(func=rebuild_orders.run)
    subparser.add_argument('--yt-token', required=True)
    subparser.add_argument('--yt-proxy', required=True)
    subparser.add_argument('--src-table', required=True)
    subparser.add_argument('--dst-table', required=True)

    subparser = subparsers.add_parser('switch_mode')
    subparser.set_defaults(func=switch_mode.run)
    subparser.add_argument('--yt-token', required=True)
    subparser.add_argument('--yt-proxies', nargs='*', default=['arnold', 'hahn'])
    subparser.add_argument('--mode', choices=['old', 'new', 'incremental'])
    subparser.add_argument('--env', choices=['prod', 'testing', 'dev'], required=True)
    subparser.add_argument('--user')

    args = parser.parse_args()
    resolve_secrets_ns(args)
    args.func(args)


if __name__ == '__main__':
    main()
