# -*- coding: utf-8 -*-

import logging

from yt.wrapper import YtClient

from travel.cpa.data_processing.lib.batch_iterator import batch_iterator


BATCH_SIZE = 5000


def run(args):
    logging.info(f'Filling slow order queue from {args.src_table} to {args.dst_table}')
    yt_client = YtClient(proxy=args.yt_proxy, token=args.yt_token)
    batches = batch_iterator(
        items=yt_client.read_table(args.src_table),
        batch_size=BATCH_SIZE,
        func=lambda x: {'partner_name': x['partner_name'], 'partner_order_id': x['partner_order_id']},
    )
    processed_rows = 0
    for batch in batches:
        yt_client.insert_rows(args.dst_table, batch)
        processed_rows += len(batch)
        logging.info(f'{processed_rows} rows inserted')
