# -*- coding: utf-8 -*-

import logging

from yt.wrapper import YtClient
import yaml
import yt.wrapper as yt

from travel.library.python.arcadia.arcadia_tools import get_arcadia_path


def create_link(yt_client: YtClient, src_root: str, src_name: str, dst_root: str, category: str) -> None:
    table_path = yt.ypath_join(src_root, category, src_name)
    link_path = yt.ypath_join(dst_root, category, 'orders')
    if not yt_client.exists(table_path):
        logging.info(f'Source table is not exists, skipping: {table_path}')
        return
    logging.info(f'Linking from {table_path} to {link_path}')
    yt_client.link(table_path, link_path, recursive=True, force=True)


def run(args):
    config_path = get_arcadia_path('travel', 'cpa', 'tools3', 'tables_config.yaml')
    with open(config_path) as f:
        config = yaml.load(f.read(), yaml.SafeLoader)

    new_root = config['roots'][args.env]
    new_root = new_root.format(user=args.user)
    old_root = new_root.replace('cpa_flow', 'cpa')
    logging.info(f'Old root: {old_root}')
    logging.info(f'New root: {new_root}')

    mode = args.mode
    if mode == 'old':
        src_root = old_root
        src_name = 'orders_mr'
    elif mode == 'new':
        src_root = new_root
        src_name = 'orders_mr'
    elif mode == 'incremental':
        src_root = new_root
        src_name = 'orders'
    else:
        raise Exception(f'{mode} is not supported')

    yt_token = args.yt_token
    yt_clients = [YtClient(proxy=p, token=yt_token) for p in args.yt_proxies]

    for yt_client in yt_clients:
        for category in config['categories']:
            create_link(yt_client, src_root, src_name, old_root, category)
