## Solomon tool

[Утилита](https://a.yandex-team.ru/arc/trunk/arcadia/travel/devops/solomon/__main__.py) для работы с объектами Соломона. 
На данный момент поддержаны только объекты: графики, дашборды и алерты.

- Графики и дашборды Соломона представлены в виде файлов в формате yaml. Алерты - в формате JSON и jinja.
- В представлении присутствует только необходимый минимум настраиваемых параметров.
- Возможна загрузка и выгрузка дашбордов и графиков, в т.ч. массовая. 
  Для алертов предусмотрена только загрузка в Соломон как массовая, так и выборочная.
- Для всех изменённых дашбордов и графиков выводится unified diff представления объектов в виде yaml.
- Поддержан режим dry-run для всех типов объектов.
- Поддержана фильтрация дашбордов и графиков по параметру service.
- Имена файлов дашбордов и графиков (без расширения `.yaml`) - это их `id`. 
  Поиск файлов дашбордов и графиков производится рекурсивно в директориях, соответствующих конкретным типам объектов.
- Используется [Solomon API v2](https://wiki.yandex-team.ru/solomon/api/v2/).
- Утилита работает только с [основным кластером](https://solomon.yandex-team.ru/) Solomon.
- Утилита позволяет работать с произвольным количеством проектов (см раздел Quickstart)
- Конфигурационный файл (`defaults.yaml`) должен находиться в директории с конфигами.
- Конфигурационный файл (`config.yaml`) должен находиться в директории с конфигами.

Примечание: представление графиков и дашбордов в виде yaml по структуре не тождественно JSON, который возвращает 
[Solomon API v2](https://wiki.yandex-team.ru/solomon/api/v2/).

Примечание: в формате yaml символы из ряда `&>!` (и другие) имеют служебную роль в некоторых случаях и строки, 
имеющие такие символы в составе, обычно необходимо заключать в одиночные кавычки `'`. 
Форматы значений некоторых полей дашбордов и графиков используют символы из этого ряда.

### Quickstart

Сперва необходимо получить персональный OAuth-токен на [специальной странице](https://oauth.yandex-team.ru/authorize?response_type=token&client_id=1c0c37b3488143ff8ce570adb66b9dfa). 
Токен нужно сохранить в файл `~/.solomon/token`:

```shell script
mkdir ~/.solomon && echo {insert token here} > ~/.solomon/token
```

Т.к. утилита аркадизирована, то необходимо её собрать:

```shell script
cd $ARCADIA_ROOT/travel/devops/solomon/
ya make -r
./solomon --help
```

Solomon-tool умеет работать с разными проектами. Для того, чтобы указать с каким проектом работать - нужно сообщить ей путь
до директории с конфигурацией нужного проекта. Это можно сделать 3-мя способами:

  * через аргумент командной строки --configs-path, например `--configs-path=travel/hotels/devops/solomon`
  * через переменную окружения TRAVEL_SOLOMON_CONFIGS_PATH, например `TRAVEL_SOLOMON_CONFIGS_PATH=travel/trains/devops/solomon`
  * записав путь в файлик `~/.solomon/configs-path`, например `echo "travel/hotels/devops/solomon" > ~/.solomon/configs-path`

Для каждого проекта его идентификатор в solomon определяется в файле config.yaml в корне директории с конфигами следующим образом:
```yamk
solomon_project: travel
```

### Завести сервис под управление утилитой

Допустим, требуется завести сервис *boiler* под управление утилитой:

#### 1. Выгружаем все графики сервиса *boiler*:

```shell script
./solomon graphs --service boiler pull
```

В результате в директорию `graphs` (если её не было, то она будет создана) будут выгружены все графики, 
в параметрах которых указано `service=boiler` (параметры можно посмотреть/задать в интерфейсе Solomon на вкладке 
Sensors -> Parameters страницы объекта). 
Имена созданных файлов формируются так: `id.yaml`, где `id` - это идентификатор объекта, уникальное имя объекта в Solomon.
Далее в `./graphs/` можно создать поддиректорию `./graphs/boiler/` и переместить все файлы графиков в неё:

```shell script
mkdir graphs/boiler
mv graphs/*.yaml graphs/boiler
```

#### 2. Выгружаем дашбоард *boiler*-а:

```shell script
./solomon dashboards pull travel_boiler
```

здесь `travel_boiler` - это `id` дашборды *boiler*-а:

Обычно в параметрах дашбордов `service` не задают, так что фильтрация с помощью опции `--service` утилиты скорей всего 
даст пустое множество дашбордов.

#### 3. Коммитим полученные файлы 

Теперь можно закоммитить созданные файлы в Аркадию.

#### 4. Возможные проблемы:

1. **Проблема**: не все объекты графиков были выгружены в п.1.
   
   **Причина**: вероятно это произошло из-за того, что у графика не выставлен параметр `service=boiler` 
   (здесь `boiler` - пример имени сервиса).
   
   **Решение**: конкретные невыгруженные графики можно выгрузить дополнительно, указав команде `pull` идентификаторы 
   (`id`) нужных объектов. Например:
   
   ```shell script
   ./solomon graphs pull travel-boiler-blackwarmer-effective-rps-test travel-boiler-blackwarmer-currenthotelindex-test
   ```
   
   Здесь `travel-boiler-blackwarmer-effective-rps-test` и `travel-boiler-blackwarmer-currenthotelindex-test` - 
   идентификаторы гипотетических объектов графиков, у которых не задан параметр `service=boiler`:

## Сценарии

### Хочу отредактировать график прямо в Соломоне

Если график уже выгружен и находится в Аркадии, то после редактирования графика в Соломоне необходимо выгрузить его 
повторно с целью обновить содержимое соответствующего файла:

```shell script
./solomon graphs pull my-graph-id
```

где `my-graph-id` - идентификатор отредактированного в Соломоне графика.

При выгрузке будет отображён unified diff изменений локального файла.
Также можно повторно выгрузить все графики, относящиеся только к определённому сервису. К примеру, для сервиса *boiler* 
это выглядит так:

```shell script
./solomon graphs --service boiler pull
```

### Хочу отредактировать/создать график в файловом представлении

Если требуется создать новый график, то копируйте файл похожего графика с новым именем файла, которое будет использовано 
как `id` нового графика (должен быть уникальным среди всех графиков на кластере Solomon).
Откройте файл графика в текстовом редакторе и произведите необходимые изменения. 
Затем обновите график в Соломоне командой:

```shell script
./solomon graphs push my-graph-id
```

где `my-graph-id` - это идентификатор графика и по совместительству имя файла (без расширения `.yaml`) графика.
Если графика с идентификатором `my-graph-id` в Соломоне не существовало, то он будет создан. 
Иначе существующий объект графика будет заменён и будет показан unified diff yaml-представления старого и нового 
состояния объекта графика.

### Хочу отредактировать много графиков/дашбордов локально

Отредактируйте объекты локально и выполните `push`.

```shell script
./solomon graphs push
```

Команда будет выполнена для всех объектов указанного типа (`graphs` или `dashboards`), файлы которых присутствуют в 
локальной файловой системе (соответственно в директориях `./graphs/` и `./dashboards/`, где обход с целью поиска файлов 
`*.yaml` осуществляется рекурсивно).
Если требуется ограничить scope некоторым сервисом, допустим *boiler*, то можно указать его имя в опции `--service`:

```shell script
./solomon graphs --service boiler push
```

### Я только хотел посмотреть diff

Для того, чтобы посмотреть к каким изменениям приведут некоторые действия утилиты, не производя этих изменений, можно 
воспользоваться режимом *dry-run*. 
Режим *dry-run* включается ключом `--dry-run` или `-n`. При этом

```shell script
./solomon -n graphs push
```

покажет какие изменения произойдут в Соломоне, если выполнить `push` всех (в случае указания опции `--service` - только 
отфильтрованной по этому признаку части) объектов, файлы которых присутствуют локально, а в случае

```shell script
./solomon -n graphs pull
```

будут показаны какие изменения в локальной файловой БД были бы произведены командой `pull`. 
В т.ч. и unified diff существующих файлов объектов, которые отличаются от объектов в Соломоне (вследствие редактирования 
либо файла, либо объекта в Соломоне).


### Как быть с дашбордами?

Работа с дашбордами как объектами не отличается от работы с графиками. 
Отличия в командах только в первом параметре, в котором указывается тип объекта. 
В случае графиков это `graphs`, в случае дашбордов это `dashboards`.

## Алерты

В общем случае будет требоваться одна команда:

```shell script
./solomon alerts push
```

### Правила определения алертов

Имя файла алерта должно быть в форме {serviceName}-{alertName}.yaml
Можно группировать алерты в каталоги {serviceName}/{alertName}.yaml

Алерт формируется при помощи шаблонов. Порядок применения:
1. Самый общий шаблон                        _base.yaml
2. Общий шаблон для test и prod :            _base.{env}.yaml
3. Общий шаблон каталога (сервиса)           {serviceName}/_base.yaml
4. Общий шаблон сервиса для test и prod      {serviceName}/_base.{env}.yaml
5. Шаблон конкретного алерта                 {alert}.yaml
6. Перегрузки алерта для test и prod         {alert}.{env}.yaml

Если необходимо, чтобы алерт был добавлен только в одном из окружений, используй ключ `only_env`.
e.g.:
```
only_env: prod # создаст алерт только в проде
```

Для джагглера ключом алерта является пара host + service, поэтому все алерты обязаны иметь разные host+service.
Иначе они будут перетираться.

Соглашения для джагглера:
   - tag = используется для аггрегации сырых событий (travel-hotels в проде, travel-hotels-testing в тестинге)
   - host = cluster (для "общекластерных" алертов) или host для похостовых (low-space, например)
   - service = имя_алерта + _service_add + '-' + env

   - Для per-host мультиалертов нужно определить поле _host, равное "{{labels.host}}"
   - Для мультиалертов с другим параметром группировки нужно определить поле _service_add с подстановкой, например
      "_service_add": "-{{labels.partner}}",

### Библиотека базовых алертов

Утилита поддерживает библиотеку базовых шаблонов проверов. Базовые шаблоны проверок находятся в `travel/devops/solomon/library` и разделены по доменным областям и далее, опционально, по экосистемам.
Для того чтобы добавить 5xx проверку для http метрик, собираемых через go библиотеку - следует искать шаблон в
`travel/devops/solomon/library/http/go/5xx.tpl`.

Для того, чтобы указать, что текущая проверка основана на базовом шаблоне проверок - стоит определить `inherited_from`.

Пример использования базовой проверки:
```
inherited_from: travel/devops/solomon/library/http/go/4xx.yaml
_program_vars:
  crit_trashold: 0.25
  warn_trashold: 0.1
```

`inherited_from` может быть использовано в шаблонах на любых уровнях переопределения, другое дело что обычно это лишено смысла.
Более того, даже если смысл есть - это *крайне не рекомендуется*, так как делает результирующую конструкцию очень не явной.

## Прочее

#### Формат поля `numberFormat` графика

`numberFormat` описывает формат чисел в легенде или на тултипе графика.
Значение в поле `numberFormat` графика выглядит так: `3|` или `0|M`, где до разделителя `|` - количество знаков после 
запятой, а суффикс из ряда `K`, `M` и т.д. - это порядок: тысячи, миллионы и т.д. (соответственно). 
Допустимо пустое значение суффикса.

#### Формат полей `min` и `max` графика

Значения полей `min` и `max` могут содержать строковое представление как просто числа, так и числа в форме `10K`.

#### Цвета линий графика

Цвета линий графика задаются строкой, содержащей HEX-представление RGB значения цвета, например `'#E9E7Ef'`, либо HTML 
color name, которое можно взять, например, из [этой таблицы](https://www.w3schools.com/Colors/colors_names.asp).
