# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import logging
import os
from dataclasses import dataclass

import yaml

from travel.library.python.arcadia import arcadia_tools


DEFAULT_CONFIGS_PATH = '~/.solomon/configs-path'
DEFAULT_CONFIGS_PATH_ENV = 'TRAVEL_SOLOMON_CONFIGS_PATH'

log = logging.getLogger(__name__)


@dataclass
class Config:
    solomon_project: str


def get_default_project_path():
    project_path = os.getenv(DEFAULT_CONFIGS_PATH_ENV)
    if project_path is not None:
        return project_path

    try:
        with open(os.path.expanduser(DEFAULT_CONFIGS_PATH), 'r') as f:
            return f.readline().strip()
    except IOError:
        return None


def build_arcadia_path(configs_path):
    configs_path_parts = [
        part for part in os.path.normpath(configs_path).split('/') if part
    ]
    return arcadia_tools.get_arcadia_path(*configs_path_parts)


def load_config(path_to_configs):
    conf_path = os.path.join(path_to_configs, 'config.yaml')
    try:
        with open(conf_path, 'r') as f:
            return Config(**yaml.load(f, Loader=yaml.FullLoader))
    except IOError:
        log.error('No project config in path %s', conf_path)
        raise
    except Exception as ex:
        log.exception('Error while parsing config in path %s: %s', conf_path, repr(ex))
        raise
