---
title: Подключение продажи отелей по прямым договорам (Travelline, BNovo)
---

## Общая схема работы

Технический поставщик (e.g. Travelline, BNovo) позволяет отелю продаваться на Яндексе, для этого отелю необходимо заключить договор с Яндексом. Отелю в общем случае необходимо согласиться с условиями договора-оферты в личном кабинете поставщика (существует так же процесс подписания ручного договора биздевами, но общая схема работы от этого меняется не сильно)

Технический поставщик оповещает Яндекс о том, что отель принял договор оферты через HTTP методы API в HotelsAdministrator

Hotels Administrator отвечает за процесс регистрации и подключения отеля в продажный контур Яндекс.Трэвел:
- убеждается в том, что отель есть в геопоиске, кластеризован и будет отображаться при поиске на портале
- [регистрирует отель в балансе](#balance-registration-process), создавая новый договор, либо привязывая подключенный отель к существующему договору (в случае нескольких отелей на одном договоре)

**Полезно помнить, что подключенный отель не равно договор.**

## Регистрация отеля в Балансе {#balance-registration-process}

При регистрации HotelsAdministrator создает в балансе три сущности Клиент (идентифицируемый ClientId), Плательщик (PersonId), Договор (ContractId).

В нашей системе приняты следующие ограничения:
- ClientId соотносится один к одному с ContractId. При заведении нового договора (e.g. в случае смены ИНН юр. лица) мы создаем новый ClientId и ContractId
- К одному договору могут быть подвязаны несколько отелей ( 1 ContractId => N HotelId), при этом один отель не может работать по нескольким договорам, чтобы отель продавался для него должен быть активный договор (с корректными данными юр. лица, реквизитами, с проставленной галочкой - Активен)  в Балансе
- Для существующего договора допускается смена платежных реквизитов, при этом нет четких гарантий на момент времени, с которого платежный контур начнет использовать эти реквизиты

## Взаимодействие Hotels Administrator и Оркестратора

После окончания процесса подключения HotelsAdministrator публикует в табличку в YT условия продажи подключенного отеля ( [prod](https://yt.yandex-team.ru/hahn/navigation?path=//home/travel/prod/hotels_administrator/hotel_agreements), [testing](https://yt.yandex-team.ru/hahn/navigation?path=//home/travel/testing/hotels_administrator/hotel_agreements)). Условия подключения отеля содержат следующую информацию:
- HotelId
- Информацию о регистрации в Балансе (BillingId, ContractId, Публичный номер договора в Балансе)
- Email для оповещения отеля (куда посылать расшифровки)
- Размер нашей комиссии
- Временное окно, в котором данные условия подключения считаются активными
Оркестратор затягивает в себя эту табличку и держит в памяти. Дополнительно из таблички выбираются все ClientId и по ним оркестратор в базе данных постоянно обновляет статус активности договора в балансе.

При бронировании в Оркестраторе в момент бронирования по HotelId находятся условия работы данного отеля с нами. По ClientId проверяется, что у отеля с нами есть заключенный договор и условия фиксируются в базе вместе с услугой. При дальнейших платежах и возвратах по услуге используется ClientId из зафиксированных условий.

## Платежи

При подтверждении и возврате, в оркестраторе создаются финансовые события, - сущности в которых содержится информация о том, какие платежи/возвраты отгрузить в биллинг для выбранного ClientId. В оркестраторе есть процесс, который в базе превращает финансовые события (`FinancialEvent`) в строчки для биллинга (`BillingTransaction`) aka **открутки**. Далее оркестратор выгружает строчки для Биллинга в [папку в YT](https://yt.yandex-team.ru/hahn/navigation?path=//home/travel/prod/billing/transactions), в таблички по дням.
Биллинг вычитывает строчки из табличек и перекладывает их в OEBS, что является сигналом для выплат партнеру. После выезда пользователя из отеля, оркестратор "актирует" строчки, вызывая для соответствующей строчки в API Баланса метод `Balance.UpdatePayment` (подробнее [здесь](billing_oebs_transport.md)).

В оркестраторе работает периодический процесc, который затягивает из Баланса информацию по платежным поручениям, и таким образом в базе оркестратора можно найти информацию о том, в какое платежное поручение попали те или иные открутки (это в том числе позволяет отвечать биздевам на вопрос, за какие брони мы перечислили деньги партнеру).

Важно помнить следующее, что если мы перечислили деньги партнеру, а через какое-то время совершили возврат, то у партнера перед нами образовалась задолженность, которая будет покрываться последующими платежами, что в свою очередь означает, что новые платежи не будут перечисляться партнеру, пока они не покроют образовавшуюся задолженность.

## Отчетность

В конце отчетного периода по договору высылаются следующие документы
- Документы, генерируемые [платежным контуром Яндекс](billing_oebs_transport.md) (Billing + OEBS)
    - отчет агента (формируется OEBS)
    - акт об оказанных услугах (формируется в Биллинге)
- Документы, генерируемые Яндекс.Travel 
    - расшифровка к отчету агента (в настоящий момент формируется в Оркестраторе на основе откруток)
    - Реестр завершенных бронирований по акту об исполнении поручения (aka расшифровка к акту об оказанных услугах, в настоящий момент формируется по отгрузкам в биллинг)
