---
title: Общие справочники
---

## Концепция

### Какую задачу решаем

Необходимо чтобы все сервисы Путешествий могли опираться на одни и те же справочные данные.

### Определение справочных данных

Справочными данными считаем данные, которые меняются сравнительно редко (доли-единицы процентов в день). Примеры: станции, населенные пункты, районы, страны, компании перевозчики, системы кодирования (станций), типы/модели транспорта.
При этом такие данные как нитки, и rtstations - справочниками не являются, так как могут значительно и быстро меняться.

### Требования

  * Быстрый доступ к данным. Так как справочники используются в самых непредсказуемых местах в бизнес логике сервисов - необходимо чтобы сервисы могли быстро получать к ним доступ.
  * Допустимо отставание данных у сервисов потребителей справочников от первоисточника не более чем на 15мин и не более чем на 0.1% от общего объема данных.
  * Отсутствие связности с экосистемой Расписаний.
  * Наличие общих переиспользуемых моделей данных.

## Реализация

### Источники данных

В качестве основного источника данных выступает сервис Расписаний. Это обусловлено тем, что именно Расписания обладают наиболее полной справочной информацией. Но при этом любой другой сервис (Авиа/Поезда/Отели) так же может экспортировать какие то свои справочники, в случае если это необходимо.

### Описание моделей

Модели общих справочников описываем в виде protobuff. Все proto-библиотеки размещаются в https://a.yandex-team.ru/arc/trunk/arcadia/travel/proto/dicts/. 
Формат записи: сообщения храним разделенные int'ами, определяющими длину следующего сообщения. 

**Codestyle:**

Сейчас бОльшая часть справочников реализована в следующем стиле:

  - именуем все в CamelCase
  - структуры именуем с префиксом T, перечисления с префиксом E
  - для C++ определяем namespace как NTravel.NDicts (**TODO:** расписания сейчас живут в NRasp.NData, нужно привести в соответствие)
  - для java определяем package как ru.yandex.travel.dicts.{service}.proto (**TODO:** может лучше ru.yandex.travel.proto.dicts.{service} ?)
  - для java определяем java_multiple_files = true

Но в связи с [общими правилами для .proto Аркадии](https://clubs.at.yandex-team.ru/arcadia/24169) теперь следуем [UberV2](https://github.com/uber/prototool/blob/dev/style/README.md)

**Структура:**

При генерации справочников не следует слепо следовать за структурой БД. В случае, если у генерируемой модели есть какие то связи, следует рассмотреть возможность включить их в модель если это логично, удобно и возможно (не взрываемся по размеру справочника/памяти). Например, у справочника станций есть связи с таймзонами, кодами и населенными пунктами. Логично и удобно таймзоны и коды добавить в справочник станций вместо того чтобы выгружать их как отдельные справочники. При этом населенные пункты добавлять в справочник станций уже не логично (хотя в некоторых ситуациях это может быть и удобно).

### Генерация

**Ресурсы**

Сгенерированные proto файлы должны заворачиваться в sandbox ресурсы. 
Ресурсы должны быть описаны тут: https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/projects/Travel/resources/dicts.py 
Ресурсы должны быть унаследованы от базового класса TRAVEL_DICT_BASE.
Ресурсы должны именоваться как TRAVEL_DICT_{service}_{object}_{environment}, где service это сервис (например RASP, AVIA), object - тип упакованных объектов (например STATION, SETTLEMENT), environment - окружения для которого сгенерирован ресурс (PROD/TESTING).

**Пайплайн генерации ресурсов Расписаний**

В Расписаниях есть такая сущность как пересчет (полный или частичный). Последним шагом каждого пересчета запускается задача [RASP_BUILD_RASP_DATA_AND_UPDATE](https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/projects/rasp/RaspBuildRaspDataAndUpdate/__init__.py?rev=6084607), она в свою очередь запускает задачу [DumpRaspData](https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/?rev=6084465) - которая генерирует ресурсы, затем задачу [RASP_QLOUD_UPDATE_RESOURCES](https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/projects/rasp/qloud/UpdateResources/__init__.py?rev=6084607) которая обновляет ресурсы в qloud окружения определенных [тут](https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/projects/rasp/qloud/resources_config.py?rev=6084607) и перезапускает эти окружения.

Непосредственно сама генерация справочников Расписаний осуществляется вот этим [приложением](https://a.yandex-team.ru/arc/trunk/arcadia/travel/rasp/rasp_data/).

**Точки расширения**

Возможны ситуации, когда имеющиеся справочники не удобны для использования. Например потому что загружаемый объем данных слишком велик или потому что приложению нужны каким то образом предрасчитанные данные. В таком случае правильным решением будет добавить в задачу RASP_BUILD_RASP_DATA_AND_UPDATE еще один шаг - задачу RASP_BUILD_RASP_DATA_POSTPROCESS_HOOK, которая бы запускала задачи, в которых выполнялись бы все необходимые предрасчеты на основе уже сгенерированных ресурсов и которые бы по результатам этих предрасчетов перезапускали бы зависимые qloud окружения. При этом задача RASP_BUILD_RASP_DATA_POSTPROCESS_HOOK должна запускаться асинхронно, то есть RASP_BUILD_RASP_DATA_AND_UPDATE не должна дожидаться окончания ее работы.

### Доставка

В qloud для окружений определяется зависимость от необходимых ресурсов, для автоматического обновления ресурсов - ссылку на окружение добавляем [сюда](https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/projects/rasp/qloud/resources_config.py?rev=6084607).
В RTC так же определяется зависимость от необходимых ресурсов, как от [динамических](https://wiki.yandex-team.ru/iss3/Specifications/configuration/resource/#dinamicheskijjresurs). Затем определяется хук iis_hook_notify.

Философия общих справочников позволяет придумывать и свои методы доставки, например:

  - класть их в какой нибудь redis 
  - etc
  
#### Доставка в YT

Словари расписаний раз в сутки выгружаются в YT на Hahn в директорию [//home/travel/prod/rasp_dicts](https://yt.yandex-team.ru/hahn/navigation?path=//home/travel/prod/rasp_dicts).

Тулза для выгрузки живёт [тут](https://a.yandex-team.ru/arc/trunk/arcadia/travel/hotels/tools/rasp_dicts_uploader/__main__.py).
Регулярный запуск производится Sandbox Planner-ом [тут](https://a.yandex-team.ru/arc/trunk/arcadia/travel/hotels/devops/sandbox_planner/plan.yaml?rev=r7839305#L545).
 

### Переводы

Поле, для которого необходима локализация представляем в виде стуктуры:

```(proto)
message TTranslation {
    Ru string = 10;
    En string = 20;
    Uk string = 30;
    // ... прочие языки.
}
```

Пример:

```(proto)
message Station {
    Title TTranslation = 1;  // по умолчанию
    TitleAccusative TTranslation = 2;  // если нужны склонения хотя бы для одного языка
    ShortTitleNominative TTranslation = 3;  // -//-
    WeirdMutiplicativeTitle TTranslation = 4;  // ну предположим мы какое то множественное число захотели
}
```

В коде предполагается использовать это так:

```(python)
from travel.library.python.dicts.locale import localize  # TODO: надо написать

def make_dict_for_stupid_consumer(station, locale):
    return {
        'title': localize(station.Title, locale),
        # для русского одна словоформа, для других - другая
        # тут можно какой то более умный хэлпер написать
        'titleAccusative': localize(station.TitleAccusative, locale) if locale == 'ru' else localize(station.WeirdMutiplicativeTitle, locale)
    }
```

## Интеграция транспортных справочников с Отелями

Интеграция возможна двумя способами:

  - для населенных пунктов и стран можно матчиться через geobase_id
  - для остальных объектов (отели, станции и тп) - матчиться можно через координаты

Например:

  * из транспортных сервисов в отели - берём координаты одного из объектов (скорее всего, объект "куда") и выполняем поиск в отелях в некотором радиусе от этого объекта;
  * из отелей в транспортные сервисы - по координатам из поискового контекста подбираем ближайший объект из транспортных, выполняем поиск до этого объекта;

## Ответственности

Ответственный за справочники - staff:lorekhov, с ним можно обсуждать все необходимые доработки и стратегию развития. Этот же человек отсматривает PR связанные с доработкой справочников.

При этом каждый сервис сам может:
  а) добавить необходимые ему данные в экспорт справочников Расписаний (согласовав это предварительно с командой Расписаний);
  б) написать свой экспорт своих данных;
