---
title: Межсервисное взаимодействие
---

## Межсервисное взаимодействие

### Backend - Backend

Для взаимодействия между сервисами backend'ов мы используем протокол gRPC.

**Обоснование:** gRPC принуждает к spec-driven development, а это значит - что спецификация API вначале будет продумана и обсуждена, и лишь потом реализована. Что в свою очередь может сэкономить пару итераций написания кода. gRPC обладает развитым тулингом для кодогенерации - описав API один раз - тривиально сгенерировать клиенты к нему для любого из разрешенных языков. gRPC типизирован, что, в купе с кодогенерацией, упрощает межсервисные рефакторинги.

В частности, если говорить про рефакторинг:

  - Переименовывать поля можно, так как в формате завязка идет на тег поля, а не на имя.
  - Легко найти все использования поля, сделав поиск по обращениям к нему или удалив временно поле и посмотрев на ошибки сборки.


Следует отметить впрочем, что есть и некоторые проблемы. 
Главное -- для gRPC на данный момент нет нормального решения в области server-side load balancing, L7 балансеры не поддерживают HTTP/2, а L3 балансеры не умеют в ретраи. Ответ - это client-side load balancing. Но и тут все не просто, потому что пока не выработано достаточно проработанное и общее решение. Для golang в travel-библиотеке есть [балансер с healthcheck-проверкой](https://a.yandex-team.ru/arc/trunk/arcadia/travel/library/go/grpcutil/client/README.md) для grpc-клиента.

**Общие правила**

  - style guide: в соответствии с [решением Аркадийной WG по единому стилю protobuff](https://clubs.at.yandex-team.ru/arcadia/24169) - используем стиль [Uber V2](https://github.com/uber/prototool/blob/dev/style/README.md), [пример](https://a.yandex-team.ru/arc/trunk/arcadia/travel/proto/resourcestorage). Это значит, что новые grpc сервисы и proto мы описываем в новом стиле. Старые - продолжаем поддерживать и развивать в соответствии со старым style-guide или (если таковое возможно малыми трудозатратами) - переводим на новый.
  - порт по умолчанию - 9001 (если нужно слушать на нескольких портах - инкрементируем на 1, то есть 9002, 9003, etc); 
  - grpc сервис должен поддерживать [health checking protocol](https://github.com/grpc/grpc/blob/master/doc/health-checking.md);
  - [коды ошибок](https://github.com/grpc/grpc/blob/master/doc/statuscodes.md) - этот пункт пока носит рекомендательный характер;

**Полезное**

  - [grpc-gateway](https://a.yandex-team.ru/arc/trunk/arcadia/travel/library/go/grpcgateway/) - позволяет работать с GRPC API через Open-API, удобно для debug'а;
  - [grpc библиотека](https://a.yandex-team.ru/arc/trunk/arcadia/travel/library/go/grpcutil) - включает в себя бойлерплейт для поднятия сервера, работу с метриками, хэлперы для клиента;

### Frontend - Backend

Здесь под "Frontend" понимается фронто-бэк, то есть nodejs часть Frontend приложения.

Backend предоставляет HTTP-API, построенное таким образом, чтобы полностью убрать с Frontend любую бизнес логику, за исключением логики представления. Frontend не должен ничего клеить, сопоставлять, вычислять, формировать. Его задача получить JSON и отобразить его в HTML.
Пример: [Travel-Api](https://docs.yandex-team.ru/travel/dev/api)  


### Общие требования

TODO: здесь про прокидывание экспериментов, трассировку и correlation-id, tvm, общие заголовки.
