---
title: Языки программирования
---

## Выбор стэка для (нового) Бэкенда

В Путешествиях для бэкендов разрешены все языки, разрешенные для бэкендов в Аркадии: [пост в Этушке](clubs.at.yandex-team.ru/mag/60148).

Но c дополнительным ограничением - нельзя писать **user-facing сервис** на Python. Главная причина этого ограничения в том, что Python - язык с динамической типизацией что на порядок затрудняет рефакторинг, эта проблема становится еще более острой в контексте взаимодействия многочисленных сервисов. Так же отсутствие статической типизации приводит к возникновению целого класса ошибок, связанных с использованием объектов не того типа, что в свою очередь повышает трудозатраты на написание тестов. Аргументом второго порядка является несовершенство runtime'а - отсутствие возможности эффективно параллелить вычислительно-интенсивные задачи в рамках одного процесса => проблемы с потреблением памяти, необходимость использования дополнительной обвязки - gunicorn для управления процессами, nginx для сбора метрик(!).   

**Определение user-facing** 
User-facing сервис - это сервис, который участвует в цепочке вызовов, обслуживающих запрос реального пользователя. Исключением можно считать разнообразные админки.

**Что выбрать?**

Для общих компонент рекомендованными являются:

  * Go - низкий порог входа, удобный рантайм (netpoller, goroutines);
  * Java - больше гибкости за счет наличия generic'ов;
  * C++ - если данная задача не может быть решена при помощи Go/Java (упираемся в performance);
  
Дальше имеет смысл смотреть на наличие компетенций. В случае если в команде есть значительные компетенции с Java - можно использовать Java. Если нет - Go.

**А если у меня уже все на Python?**

Бежать и переписывать все подряд не нужно, но при старте новых проектов стоит начинать их на Go. Либо обосновать техническую невозможность / нецелесообразность.


## С чего начать

### Golang

Начать стоит со странички [devrules](https://wiki.yandex-team.ru/devrules/Go/) (обращаем внимание на Tutorials и Awesome Go).
Продолжить - изучением [service template](https://a.yandex-team.ru/arc/trunk/arcadia/travel/library/go/service_template), это шаблон приложения на Go, демонстрирует правильный layout проекта, а так же использование общих инфраструктурных библиотек (логи, метрики, конфиги).   
Дальше имеет смысл изучить [библиотеку Go Путешествий](https://a.yandex-team.ru/arc/trunk/arcadia/travel/library/go).
[Секция devrules Go](https://wiki.yandex-team.ru/devrules/#go) тут можно подсмотреть состав коммитета.

**FAQ**

Q: Я прочитал все, но не понял, когда мне использовать указатели, а когда значения?
A: tl/dr - Указатели следует использовать тогда, когда нужно разделить владение переменной. Значения - в остальных случаях. Важно помнить, что на самом деле "значение/указатель" - это семантика типа. То есть если мы сделали тип Foo, то далее мы везде работаем с ним одним и только одним образом (всегда по значению или всегда по указателю). Исключения могут быть ради оптимизации и должны быть обоснованы профилированием.
Длинная версия: https://www.ardanlabs.com/blog/2017/05/language-mechanics-on-stacks-and-pointers.html

Q: Я слышал, что в Go есть разные практики работы с ошибками, а у нас как?
A: У нас практика ровно одна. В каждый момент времени мы принимаем решение - обработать ошибку или прокинуть ее вверх. Важно - если мы решаем обработать ошибку - то дальше мы ее не прокидываем, потому что ошибка должна быть обработана РОВНО ОДИН раз. Если мы решаем ее прокинуть выше - мы обязательно оборачиваем ее через fmt.Errorf или через [errutil](https://a.yandex-team.ru/arc/trunk/arcadia/travel/library/go/errutil), при это мы ее не логгируем (логгирование - это вариант обработки ошибки).
Подробнее можно почитать тут: [работа с ошибками в Go >= 1.13](https://blog.golang.org/go1.13-errors).
И да - паники - не ошибки.

Q: А можно мне использовать интерфейсы?
A: Да. Но помни, что интерфейсы в Go != интерфейсы в Java. В Java - классы реализуют интерфейсы и интерфейсы объявляются рядом с классами. В Go - объекты удовлетворяют интерфейсам, следовательно интерфейсы определяются по месту использования (например если у нас есть пакет redis и пакет scheduler, использующий redis.Cache, то интерфейс CacheGetter должен быть описан именно в пакете scheduler). Это позволяет снизить связность кода, а так же дает лучший контроль над тем, когда использовать интерфейс, а когда нет. Последнее важно в частности потому, что при использовании интерфейса - значение убегает в heap. Так же стоит стремиться делать интерфейсы как можно "тоньше" - в идеале 1-2 метода. Это так же снизит связность кода. 

**ZEN**

https://the-zen-of-go.netlify.app/

**Интересные посты в Этушке**

https://clubs.at.yandex-team.ru/trust/134

**Бложики**
https://dave.cheney.net/practical-go
https://www.ardanlabs.com/all-posts/

### Java

Начать стоит с [Аркадийной документации Java](https://docs.yandex-team.ru/arcadia-java/)
Продолжить изучением [Путешественнической Java библиотеки](https://a.yandex-team.ru/arc/trunk/arcadia/travel/library/java)
[Секция devrules Java](https://wiki.yandex-team.ru/devrules/#java) тут можно подсмотреть состав коммитета.

### Python

Начать стоит с [Аркадийной документации C++](https://docs.yandex-team.ru/arcadia-python/)
Продолжить изучением [Путешественнической Python библиотеки](https://a.yandex-team.ru/arc/trunk/arcadia/travel/library/python)
[Секция devrules Python](https://wiki.yandex-team.ru/devrules/#python)

### C++

Начать стоит с [Аркадийной документации C++](https://docs.yandex-team.ru/arcadia-cpp/)
[Секция devrules C++](https://wiki.yandex-team.ru/devrules/#c)
