---
title: Дежурства по подключению отелей
---

## График дежурств

Основной график — [тут](https://abc.yandex-team.ru/services/travelorchetsrator/duty/) (нижний блок)

Дежурный приступает к работе в 10:00 понедельника и отвечает на запросы в рабочее время (необходимости быть на связи 24/7 нет).

## Обязанности дежурного

* Следить за работоспособностью сервиса подключения отелей (hotels_administrator) и внешнего api (external-api), реагируя на технические алерты о проблемах в этих компонентах;
* Разбирать упавшие workflow подключения отелей (раздел "Упали с ошибкой" на дашборде), восстанавливать эти workflow, если необходимо;
* Разбираться с причинами отсутствия подключаемых отелей в Справочнике / Геопоиске;
* Применять запросы на изменение реквизитов отелей, приходящие со стороны BizDev команды;
* Отвечать на запросы BizDev-команды и партнеров, касающиеся доступности и опубликованности отелей.

## Типовые проблемы
### Отель не найден в ГП

При подключении отеля может возникать ошибка отсутствия отеля в ГеоПоиске. Чаще всего эта проблема вызвана тем, что партнер, осуществляющий подключение, ранее не передавал нам информацию об отеле и начинает передавать ее только после подключения отеля. Это значит, что мы получим эту информацию только в начале дня, следующим за подключением, при следующем обновлении фида. Далее фид будет загружен справочником, который "сварит" свою базу и поставит ее в Геопоиск через длительный процесс приемки. В результате отель может "прорасти" до геопоиска только спустя 3-4 дня после первоначальной попытки подключения.

Дежурный регулярно проверяет раздел "не найден в фиде / ГП" [дашборда подключения отелей](https://st.yandex-team.ru/dashboard/36290) на предмет тикетов, заведенных/обновленных более суток назад и вручную пытается закрыть этот тикет. Если в момент закрытия тикета отель найдется в Геопоиске, робот напишет об этом комментарий в тикете, а тикет останется закрытым. Если же отель все еще не будет доступным, робот переоткроет тикет с сообщением об ошибке.

Однако если за 3-4 дня отель так и не появится в ГП, вероятно имеет смысл поискать соответствующий сигнал в Алтае и в фиде. Бывает так, что сигнал есть в фиде, но не принимается Алтаем по той или иной причине (чаще всего — не верный или отсутствиующий адрес). В этом случае необходимо связаться с партнером для того, чтобы он на своей стороне указал корректные данные (завести тикет во внешнем трекере: в очереди соответствующей партнеру, [BNOVO](https://tracker.yandex.ru/BNOVO) или [TRAVELLINE](https://tracker.yandex.ru/TRAVELLINE))

### Неверные реквизиты при подключении отеля

Периодически отельер при заведении нового отеля на новые реквизиты может указать либо кривой БИК, либо БИК не согласующийся с расчетным счетом.
В таких случаях регистрация юр. лица упадет с ошибкой в Балансе. [Пример ошибки](https://st.yandex-team.ru/HOTELPROCESS-6049)
Последовательность действий такая:
1) Определить, какой именно отель упал (по поиску в БД или в стартреке - например по р/с)
2) Создать тикет во внешней очереди ТЛ и Бново по типу [такого](https://tracker.yandex.ru/TRAVELLINE-65).
3) Дождаться, пока отель/партнер исправит реквизиты
4) Используя Постман, получить обновленную информацию от партнера: 
   * Тревеллайн: <https://yandex.tlintegration.com/offer/hotel_details?hotel.code=123>
   * Бново: <https://api.reservationsteps.ru/v1/api/yandex_hotel_details?account_id=123&token=***> 
5) Вручную обновить БИК, Р/С, возможно КПП, в сущности `LegalDetails` для нашего отеля
6) Восстановить сообщение в `workflow_event`, восстановить `workflow`

### Изменение реквизитов 

Изменение реквизитов нужно проводить либо в полуавтоматическом, либо в ручном режиме - для старых запросов (если такие еще остались).  
Запрос можно обработать полуавтоматически, если в начале описания есть строчка типа:
> ID обновления: cfc0e90f-a0e8-4be9-b203-8ce7f5f4f4f8


#### Инструкция для полуавтоматической работы с запросами на изменение реквизитов

Например: <https://st.yandex-team.ru/HOTELPROCESS-5798>  
Далее нужно собрать CLI Администратора отсюда: <https://a.yandex-team.ru/arc/trunk/arcadia/travel/hotels/hotels_administrator/tools/administrator_cli>  
Тикеты для обработки дежурным показаны на дашборде: <https://st.yandex-team.ru/dashboard/36290>  
В зависимости от раздела нужно выполнять разные команды:
* [DEV: авт. изменение](https://st.yandex-team.ru/dashboard/36290#211195): `./administrator_cli --env prod --tvm-client-secret <TVM секрет администратора> acceptConnectionUpdate --connection-update-id <UUID>`  

* [DEV: ручн. изменение](https://st.yandex-team.ru/dashboard/36290#226546): `./administrator_cli --env prod --tvm-client-secret <TVM секрет администратора> acceptConnectionUpdate --connection-update-id <UUID> --bank-change-mode create_new`  

* [DEV: отклонить изменение](https://st.yandex-team.ru/dashboard/36290#226557): `./administrator_cli --env prod --tvm-client-secret <TVM секрет администратора> rejectConnectionUpdate --connection-update-id <UUID>`  
  Тут следует уточнить, что после отклонения изменений Администратор тут же считает данные от партнера и если они по-прежнему не совпадают с тем, что в Администраторе, то откроется новый тикет на изменение реквизитов

**[Если нужно отклонить изменения у отеля на [бумажном] договоре без перезапроса данных у партнера и обратно подключить отель](./change_scenarios/discard_hotel_connection_update)** 

<details>
    <summary>Инструкция для работы с легаси запросами на изменение реквизитов</summary>

#### Инструкция для ручной работы с запросами на изменение реквизитов (для старых запросов)

*Подключается новый отель*

|  | **Принимаем изменения** | **Отклоняем изменения** |  
|---- |-------------------------|-------------------------|
| **Подключение на новые реквизиты** | - | - |
| **Подключение на существующие реквизиты**| [Подключить новый отель с подтверждением изменения реквизитов](./change_scenarios/connect_hotel_applying_changes) | [Отклонить изменения в Юр. данных и подключить отель](./change_scenarios/reject_legal_details_changes) ||

*Меняются реквизиты у уже подключенного отеля*

| | **Принимаем изменения** | **Отклоняем изменения**|
|---- |-------------------------|-------------------------|
| **Подключение на новые реквизиты** | [Подтвердить переход на новое юр. лицо у опубликованного отеля](./change_scenarios/confirm_new_legal_details) | - |
| **Подключение на те же реквизиты** | [Подтвердить Юр. данные, пришедшие от партнера](./change_scenarios/confirm_legal_changes) | [Отклонить изменения по полям юр. лица и обратно подключить отель.](./change_scenarios/discard_legal_details_changes) |
| **Подключение на новые реквизиты, но уже зарегистрированные** | [Подтвердить Юр. данные, пришедшие от партнера](./change_scenarios/confirm_legal_changes) | - |
</details>
