---
title: Типовые рецепты
---
## Возврат денежных средств по брони
В случае, если необходимо отменить отельную бронь на условиях, отличных от стандартных, **но согласованных с партнером**, необходимо воспользоваться консольной утилитой [orders-admin](orders_admin):
1. собрать утилиту `cd travel/orders/tools/orders-admin && ya make --checkout`
2. выполнить `./orders-admin refund-hotel-order <order-id или pretty-id> --amount <сумма к возврату>`. Если необходимо вернуть 100% от суммы заказа, можно вместо `--amount <сумма к возврату>` указать флаг `--full`. Если необходимо вернуть заказ на стандартных условиях (согласно правилам возврата), ни `--amount`, ни `--full` указывать не надо. При указании значения `--amount` нужно указывать значение в рублях, отделяя копейки точкой, если необходимо.
3. в консоль будут выведены номера заказа, ссылка на заказ в админке, общая сумма заказа, сумма, причитающаяся к возврату согласно правилам и сумма, запрошенная к возврату. Если все верно, подтвердить возврат вводом "y"
4. проконтроллировать в админке, что возврат осуществлен корректно.

**Если нестандартные условия возврата не согласованы с партнером** (например, возврат осуществляется "за наш счет"), то утилите необходимо указать дополнительный флаг `--skip-fin-events` — в этом случае возврат не будет отражен во взаимораcчетах с партнером (в сверке заказ будет по-прежнему считаться выполненным). 

{% note warning %}

В этом случае перед началом возврата поддержкой должен быть заведен тикет на списание убытков.

{% endnote %}

## Восстановление заказа Дельфина, ранее переведенного в ручную обработку

Если заказ Дельфина был ранее переведен в ручную обработку (из-за попадания в WaitList и подобных проблем), после чего на стороне Дельфина был либо подтвержден, либо аннулирован, то необходимо восстановить заказ на нашей стороне и продолжить его автоматическую обработку: для подтвержденных заказов будут выписаны документы, для аннулированных - возвращены деньги.

Для этого необходимо воспользоваться консольной утилитой [orders-admin](orders_admin):
1. собрать утилиту (`cd travel/orders/tools/orders-admin && ya make --checkout`)
2. выполнить `./orders-admin restore-dolphin-order <order-id или pretty-id>`
3. перейти в админку, убедиться что заказ восстановлен и перешел в нужное состояние (CONFIRMED или  CANCELLED)
4. проверить, что автоматика отписалась в wait-list тикете в стартреке о новом состоянии

## Перегенерация ваучера

Если требуется перегенирировать ваучер для клиента, необходимо выполнить следующую последовательность действий:
1. Внести правки в заказ и услугу, отредактировав payload, можно через админку. 
2. Собрать утилиту (`cd travel/orders/tools/orders-admin && ya make --checkout`)
3. Выполнить команду `./orders-admin regenerate-voucher <order-id или pretty-id>`
4. Вернуться в админку, убедиться по логам, что ваучер перегенерировался.
5. Скачать ваучер, войдя под реквизитами гостя, убедиться, что все выглядит так, как надо
6. (опционально) Через админку инициировать повторную отправку ваучера

{% note info %} 

Многие поля, такие как суммы заказа и даты в json услуги встречаются неоднократно. При редактировании стоит убедиться, что все нужные вхождения изменены.

{% endnote %}

{% note info %} 

Ваучер следует перегенерировать всякий раз, когда меняется содержимое или описание услуг: даты проживания в отеле, название или описание номера, название или адрес отеля и тп.
При изменении стоимости перегенерировать ваучер не нужно: стоимость услуг в нем не фигурирует.

{% endnote %}



## Добавление отелей в White-List (Применимо только для Экспедии. Для остальных - использовать адимнистратор отелей)

1. Файл с двумя колонками "permalink" и "expedia id" закачиваем на https://paste.yandex-team.ru, либо иным способом (`ya upload`, либо `ya paste`). Полученная ссылка понадобится далее.
Дальнейшие операции в YQL и YT делаем от `@robot-travel-prod`.
2. Делаем бэкап [таблицы](https://yt.yandex-team.ru/hahn/navigation?path=//home/travel/prod/general/hotels_whitelist/latest/hotels_whitelist&offsetMode=row) (сохраняем рядом с другим именем).
3. Редактируем [запрос](https://yql.yandex-team.ru/Operations/XO0z8J3udjwt7cFM-E8UCHwr7zscgLdF4rPUiDW1Ix8=):
 3.1. В строке с `PRAGMA File` заменяем URL на полученный в пункте 1.
 3.2. Выполняем запрос: при этом новые данные из файла будут добавлены в таблицу (merged).

Запрос имеет именно такую структуру, какую имеет (т.е. из трёх стадий), чтобы не испротить схему исходной таблицы.

Функции `$skipFromTheEnd` и `ListSkip` пропускают строки с конца и из начала файла, закачанного в п.1, при его чтении.
В случае, если первая строка файла из п.1 содержит имена колонок, то она должна быть удалена функцией `ListSkip`. Если присутствует перевод строки после последней строки в файле, то он также считается пустой строкой и должен быть удалён функцией `$skipFromTheEnd`. В примере файл не содержал пустой строки в конце и имел первой строкой имена колонок.
Второй параметр функции `String::SplitToList` в первом случае (в теле лямбды `$toKeyValue`) - это разделитель колонок. В примере это символ табуляции "\t". Обычно это символ табуляции.
Второй параметр функции `String::SplitToList` во втором случае - это разделитель строк. Это может быть как "\r\n", так и просто "\r" или "\n". В примере - "\n". Необходимо указать именно тот разделитель, который используется в файле из п.1.
Рекомендую сначала выполнить запрос с закомментированной строкой (последний `INSERT`) `INSERT INTO WITH TRUNCATE`, чтобы удостовериться, что получится верная таблица.

## Запрос доплаты по отельному заказу

Это сценарий предполагает, что Поддержка согласовывает с Пользователем необходимость доплаты, и через призыв в тикет сообщает дежурному сумму, которую нужно запросить к доплате с пользователя.
Далее дежурному нужно:
1. Собрать утилиту orders-admin (`cd travel/orders/tools/orders-admin && ya make --checkout`);
2. Выполнить команду `./orders-admin add-extra <order-id или pretty-id> --amount <сумма-к-оплате-в-рублях>`;
3. Из выдачи утилиты (сообщение вида `Отправьте пользователю ссылку на оплату:...`) скопировать ссылку и отправить в саппортный-тикет для передачи пользователю. Ссылка эта живет долго (до даты заезда в отель) и может быть использована повторно в случае ошибки оплаты.
4. Финансовые события для взаиморасчетов с партнером будут сгенерированы автоматически после оплаты счета пользователем.

{% note warning %}

Если заказ в принципе является возвратным (со штрафом ли, без штрафа ли), то при его возврате сумма доплаты будет полностью возвращена пользователю, а если заказ невозвратен, то невозвратной является и доплата.

{% endnote %}

## Возврат отельного заказа без возврата денег пользователю

В редких ситуациях бывает необходимо изменить статус отельного заказа на "возвращен", но не возвращать при этом денег пользователю. Обычно это случается при возвратах заказов со 100% штрафом (или незаездах): мы обычно не даем пользователю возвращать такие заказы через ЛК, но отельер может сделать это на своей стороне и попросить нас синхронизировать статус заказа у нас для того, чтобы сходились сверки.
То есть нужно, чтобы заказ имел статус REFUNDED, но с пользователя был удержан 100% штраф, при этом финансовые события для взаиморасчета с отелем были сгенерированы так, как если бы заказ был полностью исполнен.

Для того, чтобы осуществить такой возврат, необходимо сделать следующее:
1. собрать утилиту `cd travel/orders/tools/orders-admin && ya make --checkout`
2. выполнить `./orders-admin refund-hotel-order <order-id или pretty-id> --amount 0`.
3. в консоль будут выведены номера заказа, ссылка на заказ в админке, общая сумма заказа, сумма, причитающаяся к возврату согласно правилам и сумма, запрошенная к возврату (должно быть 0).  Если все верно, подтвердить возврат вводом "y"
4. проконтроллировать в админке, что возврат осуществлен корректно: заказ имеет статус REFUNDED, но деньги пользователю НЕ возвращены.

{% note info %} 

При таком возврате будет сгенерировано "пустое" финансовое событие на возврат: с отеля будет удержано 0 рублей за проживание, с яндекса — 0 рублей комиссии. Это ожидаемое поведение: такое пустое событие будет корректно отработано, и во взаиморасчетах все будет корректно. Однако для "чистоты" всегда можно к команде из п2 выше дописать ключ `--skip-fin-events` — и в этом случае события на возврат не будет никакого.

{% endnote %}


