---
title: Использование Sentry
---

## Что такое Sentry

Sentry — это инструмент мониторинга, сбора и анализа ошибок, случающихся в различных развернутых сервисах. Когда где-либо в подключенном сервисе случается необработанное исключение, оно попадает в сентри, где группируется с другими подобными ошибками, аннотируется различными метаданными (id вызова, ip адрес пользователя, сервер, на котором случилось исключение и тп) и сохраняется вместе со стек-трейсом.

В travel поднята своя выделенная инсталляция sentry, доступная для всех компонентов Путешествий. Она доступна по адресу [travel-sentry.n.yandex-team.ru](https://travel-sentry.n.yandex-team.ru/travel/)

## Подключённые компоненты

В данный момент к sentry подключены сдедующие компоненты Путешествий:
* travel API:
   - [prod-окружение](https://travel-sentry.n.yandex-team.ru/travel/api-prod/)
   - [testing-окружение](https://travel-sentry.n.yandex-team.ru/travel/api-testing/)
* Оркестратор заказов:
  - [prod-окружение](https://travel-sentry.n.yandex-team.ru/travel/orders-app-prod/)
  - [testing-окружение](https://travel-sentry.n.yandex-team.ru/travel/orders-app-testing/)

Как видно, каждое окружение каждого компонента заведено отдельным проектом в sentry. Теоретически, можно заводить по проекту на компонент, а в рамках проектов заводить окружения — но этот функционал пока не используется.

## Как получить доступ

Написать в slack в воркспейсе yndx-travel в канале #devops и попросить приглашение. 

## Как использовать

Сам по себе Sentry при правильной настройке может очень многое (в том числе, например, заводить новые тикеты для неизвестных ошибок или подлинковывать известные к существующим тикетам — но интеграции со StarTrek в данный момент не существует, поэтому этот функционал у нас пока не используется), но самый простой флоу его использования выглядит следующим образом:
- В разделе Issues проекта (то есть одной конкретной инсталляции одного конкретного компонента) отображается список ошибок, по умолчанию отсортированный по времени последнего события: т.е. наиболее новые ошибки отображаются вверху. Можно поменять порядок сортировки, и, например, отосортировать по частоте повтора ошибок (более часто случающиеся отображаются выше) или по времени первого события (сначала — впервые появившиеся, полезно для поиска новых ошибок при релизах).
- Если ошибка является ожидаемой (aka не является ошибкой), ее можно пометить как resolved или ignored
- Можно поискать ошибку по произвольному тексту в ней.
- Можно поискать ошибку по произвольному тэгу. В API можно искать по URL метода, в Оркестраторе — по id Workflow и тп.

## Как добавить новый компонент

TODO

## Документация sentry
[docs.sentry.io](https://docs.sentry.io/)
