---
title: Архитектурное design review
---

**Важно:** design review проводится ДО начала работ по проекту. 

## Цель

  - формирование общей системы ценностей и вектора технического развития бэкенда Путешествий;
  - обмен знаниями и идеями между разработчиками, борьба с велосипедами;
  - мотивация разработчиков заранее продумывать архитектуру проекта, его ограничения, модели отказа, а также развитие;

## Когда требуется design review

Design review необходимо, если выполняется хотя бы одно из следующих условий:

  - проект затрагивает >= 2 команды;
  - это новый сервис;
  - проект занимает >= 1 месяц разработки;
  - если хочется;

## Состав коммитета

Для проведение design review необходимо собрать 3-х человек из lorekhov, mbobrov, tivelkov, alexcrush, kurzhumov, monitorius, maxim-k.
Крайний за решение: технический лидер проекта, отвечающий за delivery (таким образом решение коммитета имеет рекомендательный характер).

## Процесс

1. Формируется команда проекта: менеджер, тех лид, ответственный разработчик, прочие участники
2. Менеджер делает продуктовую проработку: цель, описание
3. Помечаем эпик проекта тэгом travel-design-review
4. Ответственный разработчик делает техническую проработку проекта в виде PR в travel/docs/rfc и приглашает посмотреть на него членов коммитета
5. [optional] Собирается встреча design-review (за ее организацию отвечает ответственный за проект разработчик)
6. Вносятся правки, проект дорабатывается
7. Реализуется проект

## SLA

Целимся в следующие тайминги:
SLA на просмотр PR design review - 1 день.
SLA на встречу - 1 неделя.
Предполагается, что бОльшая часть design review будет происходить в режиме отсмотра PR.

## Состав технической проработки проекта

Формализованные продуктовые требования.
Технические требования (тайминги, требования к масштабированию, требования к темпу разработки, к консистентности, можем терять данные или нет, к надежности, etc).
Высокоуровневый дизайн: 

  - задействованные компоненты и их взаимодействие (в картинках);
  - как затрагивает имеющуюся функциональность;
  - новые API, изменение имеющихся API
  
В случае появления новых сервисов, для каждого сервиса:

  - его зона ответственности (домен);
  - примерная стратегия развития сервиса (что в него пихаем, что не пихаем);
  - описание архитектуры (язык, runtime, API, используемые хранилища, [optional] библиотеки);
  - модель данных (верхнеуровнево);
  
Модели отказа: что будет если выйдет из строя компонент A, а если B, а если база?
Собираемые метрики (свыше [базового набора](https://docs.yandex-team.ru/travel/rfc/metrics#minimalnyj-nabor-metrik-i-alertov)) и алерты.
Работа с персональными данными, при их наличии.
План выкатки в production (флаги эксперимента, выкатка на процент и тп).

Все это оформляем в виде PR в travel/docs/rfc.

П.С.: Следует применять здравый смысл, и если какая то из секций не релевантна - не стоит включать ее в итоговый документ.

## FAQ

**У меня есть проект, который не попадает под формальные критерии design review, но мне хочется чтобы на него посмотрели, что делать?**
Организовывать design review. Аргумент "хочется" - один из формальных критериев.

**Мой проект попадает под формальные критерии design review, но это обычный переезд**
Стоит применить здравый смысл. Если в рамках проекта нам надо принимать решения, которые затронут другие команды (общие инструменты / соглашения / практики) -  design review имеет смысл провести. Если нет - не нужно.

**Мне нужно сделать быстрый эксперимент, кажется что design review меня замедлит**
Если эксперимент правда быстрый и локальный - то он не попадает под критерии.
Если эксперимент затрагивает разные команды - все равно нужен этап согласования, а это, по факту, design review.
Если "быстрый" эксперимент >= 1 месяца - нет смысла экономить на design review:
  - затраты не значительны по сравнению с общим сроком разработки
  - зато больше риски заплатить гораздо больше в long run
Если эксперимент быстрый, локальный и причина design review в том - что это маленький новый сервис. Нужно сделать маленькое design review. Ключевые моменты: область ответственности сервиса, как его будем развивать, модель отказов (чтобы быть уверенными что мы подумали - как не уложить прод новым микросервисом).

**Мне нужно быстро! А на design review будут склонять делать правильно.**
Скорость delivery это на самом деле одно из архитектурных требований (если она обоснована).
Зато можно посоветоваться и, возможно, или найти способ сделать быстро и правильно, или придумать нормальный roadmap развития сервиса.

**А какова судьба всех этих travel/docs/rfc?**
Они превращаются в документацию проекта. Либо перемещаются в travel/docs/dev либо в проектные README (зависит от того, как принято работать с документацией в рабочей группе).

**Что если это решение, которое мы хотим выкинуть? Разовая акция например**
Если мы в этом уверены - тратить время на design review кажется не целесообразным. 
