---
title: Политики работы с персональными данными
---

В целом мы соответствуем [общим политика работы с ПД в Яндексе](https://wiki.yandex-team.ru/security/awareness/skarif/policy/).

**Примеры персональных данных в Путешествиях**
  - БД Оркестратора - это "Особо чувствительные приватные данные"
  - CPA - (так как там есть yandexuid, icookie и данные по заказам) - "Чувствительные приватные данные"

Что это значит - читаем [тут](https://wiki.yandex-team.ru/security/awareness/skarif/policy/#minimalnyestandartypolitikdostupa)

**Как выдаем доступы**

Выбирая объект для выдачи прав / доступов следует руководствоваться следующими соображениями. Первое - площадь: мы стараемся выдать доступ только тем людям, которым он реально нужен. Если в выбранном объекте (например ABC группе) есть люди, которым доступ не нужен - стоит подумать о другом объекте. Второе - актуальность: люди ротируются, приходят и уходят, стаффовая структура меняется раз в год. Следует стараться выбирать наиболее актуальные объекты (например ABC группы).
Исходя из вышесказанного **лучший способ выдать доступ - на ABC Группу + Роль**. ABC группа - наиболее персистентная сущность, а Роль позволяет ограничить количество людей с доступами.
В случае если выдать доступ на ABC + Роль не возможно можно выдать доступ на ABC группу, если она строго специфична, подконтрольна руководителю и в ней точно не появится случайных людей. Иначе лучше выдавать на staff группу.
На людей выдаем доступы временные или в том случае - если все остальное не работает (пример - responsible в YT).

**Терминология**

Роль "Дежурство" - множество которое включает роль текущего дежурного и роль из которой назначаются дежурные.
Роль "Руководитель группы" - любая роль, позволяющая определить текущего руководителя группы разработки, поддерживающей данный сервис. Можно использовать "Руководитель сервиса".

## По поверхностям

### YT

Для человеческих пользователей выдаем доступ на папки с персональными данными на ABC Группа + Роль.
Для роботов все как обычно.
Ответственный может быть только один и только человек. Имеет смысл делать ответственным руководителя подразделения, в общем случае - технического директора.

### MDB:

**PG**
Управление доступом до непосредственно PG БД.
Самая сложная поверхность. В общем случае нет возможности удобно манипулировать сетевыми доступами (доступы выданы по умолчанию на сети вида _PGAASINTERNALNETS_). Так же нет возможности сделать интеграцию с idm на уровне СУБД.
Разграничение доступов до production делаем по пользователям СУБД:
  - сервисы ходят из под своих пользователей, доступ до сервисных секретов есть у Руководителя группы (*);
  - прочие ходят от своих пользователей, доступ до их секретов - персональный;
  - в общем случае - доступы до БД выдаются людям, с ролью Дежурство ('** )

Требований к ограничению доступов до testing окружений нет. Можно ходить от одного пользователя без ограничений.

'* Выдавать доступ до production секрета робота / сервиса Дежурным нет смысла, так как в целом можно легко скопировать и сохранить секретик.
'**  тут есть понятная проблема - дежурные могут приходить и уходить, как это решать пока не понятно. Из вариантов видится только регулярный пересмотр пользователей.

Управление доступом до yc.
Роль "Администратор баз данных" выдается роли "Дежурство".
Роль "Пользователь баз данных" - разработчикам.

Управление доступами до чувствительных данных:
Хорошей практикой будет сделать тонкую настройку привелегий пользователей на уровне ролей СУБД таким образом, чтобы доступ до таблиц с данными которые определяются как "ключ" (email/fio/etc) был выдан только тем пользователям, которым они реально нужны. В общем случае это <= Дежурство.

**YDB**

[Документация](https://ydb.yandex-team.ru/docs/concepts/internal/iam)

TL/DR:

  - бэкенды ходят с использованием tvm
  - пользователи из скриптов ходят с использованием **личных** OAuth токенов, в том числе и роботы
  - пользователи через yql/yc консоль аутентифицируются по Session_id

Доступы так же выдаем на ABC + Роль.
Выдавать личные доступы на время технической возможности нет - потому, если такая возможность возникает - необходим ручной контроль.

По какому принципу выдаем роли:
  - группа поддерживающая сервис, использующий БД - full
  - роботы - read / write / read + write в зависимости от необходимости
  - внешние люди (аналитики / соседние команды) - в общем случае read

**Clickhouse**

См. раздел про PG.
Все механики и подходы идентичны.

**S3/Object Storage/Redis/Mongo**
В общем случае НЕ рекомендуются как хранилища в которых могут быть ПД.

### YP (Deploy/Nanny)

[Ссылка на пост с подробностями](https://clubs.at.yandex-team.ru/infra-cloud/2455)

**Для Deploy:**
  - Руководитель сервиса и Дежурство - рутовый доступ до всех окружений;
  - Разработчики: рутовый доступ до тестинга, nobody до production;

**Для Nanny:**
  - Руководитель сервиса и Дежурство - рутовый доступ до всех окружений;
  - Разработчики: рутовый доступ до тестинга;

Замечание - рутовый доступ выдаем именно на роль Дежурство, а не на текущего дежурного, потому что кажется что риск того дежурный не доступен или не может исправить проблему выше чем риск того, что кто то из ответственных за сервис сольет ПД или сделает что то нехорошее.

