---
title: Процесс работы над задачами в st/TRAVELBACK
---

Здесь описывается, что, как и когда происходит с задачами в очереди [TRAVELBACK](st.yandex-team.ru/TRAVELBACK)

Дашборд разработки находится [тут](https://st.yandex-team.ru/agile/board/9396). По нему должно быть можно всегда понять кто и какими задачами занимается. Для этого в том числе необходимо своевременно следить за актуальностью статусов по задачам.

## Создание задачи

Новая задача может быть создана менеджерами, разработчиками и тестировщиками. Обычно новая задача создается без назначения на конкретного `Исполнителя`, но если точно известно, кто будет делать задачу - то можно указать исполнителя.
`Статус` новой задачи должен быть `Открыт`.
Если новая задача относится к какому-то [проекту](https://wiki.yandex-team.ru/travel/hotels/projects/), то она должна быть под-эпиком соответствующей задачи из очереди `HOTELS`.
Для технических задач есть соответствующий эпик: [HOTELS-4920](https://st.yandex-team.ru/HOTELS-4920)

## Планирование задачи

Еженедельно происходит планирование, на котором задачи распределяются по разработчикам. Распределение производит тимлид команды разработки, в соответствии с текущими приоритетами. 
Задача, взятая запланированная на ближайшую неделю переводится из `Открыт` в `Можно делать`

## Разработка
Когда у разработчика освобождается квант времени от текущих задач, он берет одну из задач в статусе `Можно делать` и переводит её в статус `В работе`.

В процессе разработки разработчик может обнаружить, что по задаче не хватает информации, в таком случае задача нужно перевести в статус `Требуется информация` с призывом того, кто может предоставить информацию (если неизвестно - тимлида). При 

Если задача была вытеснена более приоритетной, то задачу можно перевести обратно из `В работе` или даже `Открыт`, если продолжения работ по ней не предвидится как минимум до ближайшего планирования.

Если код по задаче написан и отправлен на ревью, то задачу стоит перевести в `На ревью`.

## Тестирование в тестинге

**Важно!** После того как код влит в транк (с ревью или без), код автоматически попадает на тестинг, и может попасть в прод в ближайшем релизе. Если код содержит опасные изменения, то лучше их сделать под feature-flag-ом, управляющимся через конфиг, и флаг в prod-окружении оставить выключенным.

Тестирование является неотъемлемой частью процесса разработки, и должно выполняться всегда.

Тестирование разработчик может проводить самостоятельно, а может попросить помощи у тестировщиков. 

Тестировщики привлекаются по предварительному согласованию (например, договорились на планировании, тогда в комментарии к задаче менеджер/тестировщик прописывает необходимость провести задачу через флоу тестирования) либо, если разработчик считает, что необходима помощь тестировщика.

**Rules of thumb**:
* Были внесены изменения, меняющие логику взаимодействия пользователя с продуктом;
* Были задеты компоненты, влияющие на взаимодействие, и нужно убедиться, что ничего не сломалось.


## Тестирование в тестинге силами разработчика
Разработчик самостоятельно проверяет, что написанный код работает корректно. 
**Важно** После тестирования разработчик должен описать в задаче, что и как он проверял, и переводит задачу в статус `Протестировано` (кнопкой `Протестировано без тестировщика`). Если тестирование выявило проблемы/ошибки - то задача переводится обратно в `В работе`

## Тестирование в тестинге силами тестировщиков
Разработчик переводит задачу в статус `Можно тестировать`, предварительно описав, что именно нужно проверить. 
Далее тестировщик проверяет задачу, и, если всё хорошо, переводит её в `Протестировано`. Если тестирование выявило проблемы/ошибки - то задача переводится в `Есть замечания`.

## Выкатка в прод
Разработчик ответственен за выкатку кода своей задачи в прод.
Поэтому после того, как задача переведена в `Протестировано` разработчик должен произвести выкатку в прод дополнительно либо включив соответствующий флаг в конфиге прода, либо убрав проверку флага вообще.

После выкатки в прод необходимо провести тестирование в проде: аналогично, силами разработчика или тестировщиков

### Общие слова про мониторинг и тестирование после выкладки
Необходимо убедиться после выкатки, что на графиках не появилось неожиданных аномалий (e.g. забивающиеся очереди, чрезмерное потребление CPU). Дополнительно, хорошей практикой является бронирование на проде после выкатки исправлений в оркестраторе следует помнить рекомендации по бронированию, описанные вот [тут](https://wiki.yandex-team.ru/travel/boy/testing/)

## Тестирование в проде силами разработчика
Производится аналогично тестированию в тестинге: Разработчик самостоятельно проверяет, что написанный код работает корректно. 

## Тестирование в проде силами тестировщика
Если необходима помощь тестировщика в проде/проверить выкатившийся функционал в проде, то задача после выкатки переводится в статус `Готово к Бета-тестированию`, дополнительно стоит приложить комментарии с рекомендациями о том, как протестировать в проде.

## Закрытие задачи
После того, как задача успешно протестирована на проде, разработчик закрывает задачу с резолюцией `Решен`.

**Важно** *Закрывает задачу именно разработчик и только после выкатки и проверки в проде.* Если нужно удалить неиспользуемые feature-flag-и, то это нужно сделать  до закрытия задачи (включая выкатку в прод версии кода без feature-flag-ов). Либо, если планируется проведение эксперимента, чтобы задача не засоряла колонку и не висела без движения, можно завести новую задачу, на отрыв флагов.
