---
title: Пример design review
---

# Пример типичного design review

## Формализованные продуктовые требования.

Необходимо на поисковой выдаче Авиа, в зависимости от поискового контекста, предлагать пользователю правильных Сепулек.
По одному и тому же поисковому контексту должна возвращаться одна и та же Сепулька.
Время жизни Сепульки - 3 дня.
Нужно запустить к сентябрю (начало сезона Сепулек).

## Технические требования 

Суммарный rps - 100
Требования к времени ответа Q99 - 50ms


## Высокоуровневый дизайн.

Схема взаимодействия: 
TravelFront --search--> avia-api-gateway --search--> ticket-daemon-api
                                         --getSepulka--> sepulkariy

**sepulkariy**
Сервис, ответственный за предоставление информации о Сепульках. По месту обитания умеет подобрать нужную Сепульку.
Пишем на kotlin, в качестве кэша используем redis. Сепульки генерируем на etherium-nodes. Как только Сепулька сгенерирована - кэшируем ее в Redis с нужным TTL.

Из внешних зависимостей - etherium-node, взаимодействие через Solidity ABI.

API:
  - getSepulka(string pointTo, Date when): Sepulka

Модель данных:
Ключевая модель - Sepulka (string point, Date created, Date validTo, string color, string Name, string contractToken)

Roadmap:
Планируем подключать больше вертикалей. Так как генерация новых Сепулек будет происходить все дольше - добавим очереди и фоновые процессы по генерации.
Добавим функционал polling'а.

## Failure modes 

В случае отказа etherium-node - sepulkariy продолжает работать, срабатывает alert, дежурный должен в плановом порядке восстановить сервис.
В случае отказа redis node - sepulkariy должен автоматически переключиться на живую реплику. 
В случае отказа redis ВООБЩЕ - sepulkariy не отвечает. redis должен восстановиться из snapshot + AOF.
В случае отказа sepulkariy - avia-api-gateway и travel-front должны продолжать работать, за исключением Сепульковой функциональности.
В случае если sepulkariy отвечает медленнее 50ms - avia-api-gateway и travel-front не должны дожидаться ответа sepulkariy, чтобы не нарушить своих гарантий по latency.

## Метрики

Кроме [базового набора](https://docs.yandex-team.ru/travel/rfc/metrics#minimalnyj-nabor-metrik-i-alertov) собираем:
  - количество сепулек
  - время генерации сепулек [тут алерт]

## План выкатки в production

1. Выкатываем и проверяем sepulkariy
2. Выкатываем avia-api-gateway под флагом
3. Выкатываем travel-front (он не должен ломаться изза отсутствия Сепулек)
4. Включаем флаг
5. Выпиливаем флаг

# Пример "маленького design review"

## Формализованные продуктовые требования.
На портале должны появится Недолинковки. Где Недолинковка - это тоже самое что Перелинковка, но наоборот.

## Высокоуровневый дизайн.

Сервис недолинковок.
Область ответственности: предоставлять Порталу Недолинковки по вкладкам вертикалей.
Сервис хранит Недолинковки в файлах на диске в csv. Туда они попадают случайным ручным образом от менеджеров.
В дальнейшем добавим Недолинковки для направлений. 
Модель отказа: если сервис Недолинковки не работает - все должно быть пофиг.
