---
title: Спецификация API
---

# Схема взаимодействия
<br/>

![Диаграмма взаимодействия](_assets/sequence_diagram.png)

# API

## Отели

Методы для работы с данными отеля, которые представлены [моделью Hotel](#hotel).

### Перезаписать данные обо всех отелях
`POST /hotels/`

```json
{
    "hotels": [
        <Hotel 1>,
        <Hotel 2>,
        ...,
        <Hotel N>
    ]
}
```

### Перезаписать данные об одном отеле
`POST /hotels/<hotelId>/`

```json
<Hotel>
```

### Получить данные обо всех отелях
`GET /hotels/`

```json
{
    "hotels": [
        <Hotel 1>,
        <Hotel 2>,
        ...,
        <Hotel N>
    ]
}
```

В заголовке `ETag` содержится версия данных, которую можно использовать при сохранении в заголовке `If-Match`, чтобы избежать коллизий.

### Получить данные об одном отеле
`GET /hotels/<hotelId>/`

```json
<Hotel>
```

### Удалить данные об отеле
`DELETE /hotels/<hotelId>/`

## Предложения отелей

Методы для работы с предложениями отелей. Предложение это номер с ценами, заданными для разных условий размещения. Оно представлено моделью [Offer](#offer).

### Перезаписать данные обо всех предложениях отеля
`POST /hotels/<hotelId>/offers/`

```json
{
    "offers": [
        <Offer 1>,
        <Offer 2>,
        ...,
        <Offer N>
    ]
}
```

Перезаписывает сохранённый список предложений для указанного отеля.

### Перезаписать данные об одном предложении отеля
`POST /hotels/<hotelId>/offers/<offerId>/`

```json
<Offer>
```

Перезаписывает сохранённое предложение. Может быть использовано для изменения доступности номеров.

### Получить все предложения отеля
`GET /hotels/<hotelId>/offers/`

```json
{
    "offers": [
        <Offer 1>,
        <Offer 2>,
        ...,
        <Offer N>
    ]
}
```

Получает сохранённый список предложений для указанного отеля.

В заголовке `ETag` содержится версия данных, которую можно использовать при сохранении в заголовке `If-Match`, чтобы избежать коллизий.

### Получить одно предложение отеля
`GET /hotels/<hotelId>/offers/<offerId>/`

```json
<Offer>
```

Получает сохранённое предложение для указанного отеля.

### Удалить одно предложение отеля
`DELETE /hotels/<hotelId>/offers/<offerId>/`

## Данные о заказах

### Отправить данные о заказах
`POST /orders/`

```json
{
    "orders": [
        <Order 1>,
        <Order 2>,
        ...
        <Order N>
    ]
}
```

Сохраняет данные о заказах, которые представлены [моделью Order](#order).

# Модели

## Hotel {#hotel}

Пример:
```json
{
    "id": "1000",
    "names": [
        "Борвиха Hotel&Spa",
        "Borviha Hotel&Spa"
    ],
    "urls": [
        "https://example.org/borviha"
    ],
    "phones": [
        "88005506818",
        "+7 (38341) 2-50-32"
    ],
    "emails": [
        "hotelborviha@yandex.ru"
    ],
    "address": {
        "country": "Россия",
        "region": "Новосибирская область",
        "district": "Каменский городской округ",
        "settlement": "Бердск",
        "postalCode": "633011",
        "streetAddress": "ул. Морская, д. 3/1"
    },
    "geo": {
        "latitude": 54.786742,
        "longitude": 83.051871
    },
    "starRating": 4,
    "features": {
        "tvInRoom": true,
        "beachLine": "beach_line_third"
    },
    "photos": [
        {
            "url": "https://www.travelline.ru/resource/images/rt/148109/637613534741813756-99d4ab3c-6a6e-4457-b96a-2b4b9ea2dac7"
        }
    ]
}
```

| Поле                    | Обязательное? | Тип        | Описание                                                                                            |
|-------------------------|---------------|------------|-----------------------------------------------------------------------------------------------------|
| `id`                    | да            | `String`   | Уникальный идентификатор отеля. Используется для изменения данных об этом отеле и его предложениях. |
| `names`                 | да            | `String[]` | Названия отеля.                                                                                     |
| `urls`                  | нет           | `String[]` | Адреса веб-сайтов отеля.                                                                            |
| `phones`                | нет           | `String[]` | Телефоны отеля.                                                                                     |
| `emails`                | нет           | `String[]` | Адреса email отеля.                                                                                 |
| `address`               | да            | `Object`   | Адрес отеля.                                                                                        |
| `address.country`       | да            | `String`   | Страна.                                                                                             |
| `address.region`        | нет           | `String`   | Область.                                                                                            |
| `address.district`      | нет           | `String`   | Район.                                                                                              |
| `address.settlement`    | да            | `String`   | Населённый пункт.                                                                                   |
| `address.postalCode`    | нет           | `String`   | Почтовый индекс.                                                                                    |
| `address.streetAddress` | да            | `String`   | Улица и дом.                                                                                        |
| `geo`                   | да            | `Object`   | Гео координаты отеля.                                                                               |
| `geo.latitude`          | да            | `Number`   | Широта.                                                                                             |
| `geo.longitude`         | да            | `Number`   | Долгота.                                                                                            |
| `starRating`            | нет           | `Number`   | Звёздность отеля.                                                                                   |
| `features`              | нет           | `Object`   | Удобства отеля. Возможные поля и допустимые значения перечислены ниже. (TODO)                       |
| `photos`                | нет           | `Object[]` | Фотографии отеля.                                                                                   |
| `photos[].url`          | да            | `String`   | Адрес фотографии.                                                                                   |

## Offer {#offer}

Пример:
```json
{
    "id": "offer_id",
    "url": "https://example.org/offer/12345",
    "name": "Двухместный номер",
    "roomCount": 1,
    "features": {
        "boardBasis": "HB",
        "wifi": true
    },
    "tariffs": [
        <Tariff 1>,
        <Tariff 2>,
        ...
        <Tariff N>
    ]
}
```

| Поле                  | Обязательное? | Тип        | Описание                                                                                      |
|-----------------------|---------------|------------|-----------------------------------------------------------------------------------------------|
| `id`                  | да            | `String`   | Уникальный идентификатор предложения. Используется для изменения данных об этом пр едложении. |
| `url`                 | да            | `String`   | Адрес лендинга. Параметры запроса: [Параметры лендинга](#urlQueryParams).                     |
| `name`                | да            | `String`   | Название предложения.                                                                         |
| `roomCount`           | нет           | `Number`   | Количество комнат у номера.                                                                   |
| `features`            | нет           | `Object`   | Удобства в номере.                                                                            |
| `features.boardBasis` | нет           | `String`   | Питание. Возможные значения перечислены [ниже](#boardTypes).                                  |
| `features.wifi`       | нет           | `Boolean`  | Наличие wi-fi.                                                                                |
| `tariffs`             | да            | `Object[]` | Тарифы предложения. Модель [Tariff](#tariff).                                                 |

### Виды питания {#boardTypes}

| Код   | Описание                                  |
|-------|-------------------------------------------|
| `AI`  | All inclusive                             |
| `BB`  | Bed and breakfast (Завтрак)               |
| `FB`  | Full board (Завтрак, обед, ужин; пансион) |
| `HB`  | Half board (Завтрак и ужин; полупансион)  |
| `RO`  | Без питания                               |
| `UAI` | Ultra All Inclusive                       |
| `LAI` | Light All Inclusive                       |
| `BD`  | Только ужин                               |

### Параметры лендинга {#urlQueryParams}

| Параметр             | Количество | Описание                                                                                                     |
|----------------------|------------|--------------------------------------------------------------------------------------------------------------|
| `token`              | 1          | Токен перехода на лендинг.                                                                                   |
| `checkIn`            | 1          | Дата заезда в формате ISO.                                                                                   |
| `checkOut`           | 1          | Дата выезда в формате ISO.                                                                                   |
| `adults`             | 1          | Количество мест для взрослых.                                                                                |
| `childAge`           | 0...∞      | Возраст ребёнка. При поиске размещения для нескольких детей будет передано несколько параметров.             |
| `tariffs.groupId`    | 0...1      | Идентификатор группы тарифов.                                                                                |
| `tariffs.id`         | 0...∞      | Идентификаторы выбранных тарифов. При [группировке](#tariffGroups) будет передано несколько идентификаторов. |
| `tariffs.switchDate` | 0...∞      | Даты начала действия тарифов внутри [группы](#tariffGroups).                                                 |

## Tariff {#tariff}

Тариф содержит в себе правила для применения, стоимость одного дня проживания и условия возврата. Правила задают условия для параметров поиска: даты проживания и гостей.

Пример:
```json
{
    "id": "basic_tariff",
    "groupId": "tariff_group",
    "conditions": {
        "dates": [
            "2022-05-01",
            "2022-05-02",
            "2022-05-03"
        ],
        "occupancy": {
            "adults": 2,
            "childrenAges": [3, 4]
        }
    },
    "rate": {
        "amount": "5000",
        "currency": "RUB"
    },
    "refundRules": [
        {
            "type": "fullyRefundable",
            "endsAt": "P3D"
        },
        {
            "type": "refundableWithPenalty",
            "startsAt": "P3D",
            "endsAt": "P1D",
            "penalty": {
                "amount": "500",
                "currency": "RUB"
            }
        },
        {
            "type": "nonRefundable",
            "startsAt": "P1D"
        }
    ]
}
```

Ещё больше примеров в разделе [Примеры тарифов](#tariffExamples)

| Поле                  | Обязательное? | Тип        | Описание                                                                                                        |
|-----------------------|---------------|------------|-----------------------------------------------------------------------------------------------------------------|
| `id`                  | да            | `String`   | Идентификатор тарифа. Передаётся в параметрах перехода на лендинг.                                              |
| `groupId`             | нет           | `String`   | Идентификатор группы тарифа. Используется для [объединения](#tariffGroups) нескольких тарифов.                  |
| `conditions`          | да            | `Object`   | Правила применения тарифа. Модель [Conditions](#conditions).                                                    |
| `rate`                | да            | `Object`   | Стоимость одних суток проживания по данному тарифу. Модель [Money](#money).                                     |
| `refundRules`         | нет           | `Object[]` | Условия возврата. При отсутствии этого значения тариф считается невозвратным. Модель [RefundRule](#refundRule). |

## Conditions {#conditions}

Правила для применения тарифа.

| Поле            | Обязательное? | Тип        | Описание                                                                                       |
|-----------------|---------------|------------|------------------------------------------------------------------------------------------------|
| `dates`         | да            | `Object[]` | Даты проживания. Допустимые значения списка: [DateRange](#dateRange) и строки с датами в ISO.  |
| `occupancy`     | да            | `Object`   | Гости. Модель [Occupancy](#occupancy)                                                          |
| `days`          | нет           | `Object`   | Количество дней проживания. Допустимое значение: `Number > 0` или [NumberRange](#numberRange)  |
| `weekdays`      | нет           | `String[]` | Дни недели. Возможные значения: `"mon", "tue", "wed", "thu", "fri", "sat", "sun"`              |

## DateRange {#dateRange}

Диапазон дат.

Пример диапазона с 1 мая по 10 мая:
```json
{
    "min": "2022-05-01",
    "max": "2022-05-10"
}
```

| Поле  | Обязательное? | Тип        | Описание                                                        |
|-------|---------------|------------|-----------------------------------------------------------------|
| `min` | да            | `String`   | Минимальная дата в формате ISO.                                 |
| `max` | да            | `String`   | Максимальная дата в формате ISO. Должна быть больше даты `min`. |

## Occupancy {#occupancy}

Условия для гостей.

Пример:
```json
{
    "adults": 2,
    "childrenAges": [3, 4]
}
```

| Поле           | Обязательное? | Тип        | Описание                                                                                                                     |
|----------------|---------------|------------|------------------------------------------------------------------------------------------------------------------------------|
| `adults`       | да            | `Object`   | Количество мест для взрослых. Допустимое значение: `Number > 0` или [NumberRange](#numberRange)                              |
| `childrenAges` | нет           | `Object[]` | Места с ограничением возраста задаются списком возрастов. Допустимые значения: `Number >= 0` или [NumberRange](#numberRange) |

## NumberRange {#numberRange}

Диапазон целых чисел.

Пример:
```json
{
    "min": 2,
    "max": 10
}
```

| Поле  | Обязательное? | Тип      | Описание                                                                                                                                  |
|-------|---------------|----------|-------------------------------------------------------------------------------------------------------------------------------------------|
| `min` | нет           | `Number` | Минимальное значение. При отсутствии считается равным минимально допустимому значению: `1` для `adults` и `days`, `0` для `childrenAges`  |
| `max` | да            | `Number` | Максимальное значение.                                                                                                                    |

## RefundRule {#refundRule}

Условия возврата.

Пример:
```json
{
    "type": "refundableWithPenalty",
    "startsAt": "P3D",
    "endsAt": "P1D",
    "penalty": {
        "amount": "500",
        "currency": "RUB"
    }
}
```

| Поле       | Обязательное? | Тип      | Описание                                                                                                                                               |
|------------|---------------|----------|--------------------------------------------------------------------------------------------------------------------------------------------------------|
| `type`     | да            | `String` | Тип условия. Одно из значений: `"fullyRefundable", "refundableWithPenalty", "nonRefundable"`                                                           |
| `startsAt` | нет           | `String` | Длительность от начала действия условия до даты заезда. Задаётся в формате ISO. При отсутствии считается что условие не ограничено датой начала.       |
| `endsAt`   | нет           | `String` | Длительность от окончания действия условия до даты заезда. Задаётся в формате ISO. При отсутствии считается что условие не ограничено датой окончания. |
| `penalty`  | нет           | `Object` | Штраф при отмене. Модель [Money](#money). Обязательное для `"refundableWithPenalty"`.                                                                  |

## Money {#money}

Денежная сумма.

Пример:
```json
{
    "amount": "500",
    "currency": "RUB"
}
```

| Поле       | Обязательное? | Тип      | Описание           |
|------------|---------------|----------|--------------------|
| `amount`   | да            | `String` | Сумма.             |
| `currency` | да            | `String` | Код валюты по ISO. |

## Order {#order}

Заказ в отеле.

Пример:
```json
{
    "id": "orderId",
    "token": "123e4567e89b12d3a456426614174000",
    "hotelId": "hotelId",
    "offerId": "offerId",
    "status": "booked",
    "checkIn": "2020-05-01",
    "checkOut": "2020-05-05",
    "price": {
        "amount": "10000",
        "currency": "RUB"
    }
}
```

| Поле       | Обязательное? | Тип      | Описание                                                               |
|------------|---------------|----------|------------------------------------------------------------------------|
| `id`       | да            | `String` | Идентификатор заказа. Должен быть уникальным для обновления состояния. |
| `token`    | да            | `String` | Токен перехода, переданный в [параметрах лендинга](#urlQueryParams).   |
| `hotelId`  | да            | `String` | Идентификатор отеля.                                                   |
| `offerId`  | да            | `String` | Идентификатор оффера.                                                  |
| `status`   | да            | `String` | Состояние заказа. См. [список возможных значений](#orderStatus).       |
| `checkIn`  | да            | `String` | Дата заезда в формате ISO.                                             |
| `checkOut` | да            | `String` | Дата выезда в формате ISO.                                             |
| `price`    | да            | `String` | Сумма заказа.                                                          |

### Состояния заказа {#orderStatus}

| Значение    | Описание      |
|-------------|---------------|
| `booked`    | Забронирован. |
| `completed` | Выполнен.     |
| `canceled`  | Отменён.      |

# Примеры тарифов {#tariffExamples}

Тариф для 1-2 взрослых гостей, доступный в любые даты с 1 мая по 1 октября:
```json
{
    "conditions": {
        "dates": [
            {
                "min": "2022-05-01",
                "max": "2022-10-01"
            }
        ],
        "occupancy": {
            "adults": {
                "max": 2
            }
        }
    },
    "rate": {
        "amount": "1000",
        "currency": "RUB"
    }
}
```
При поиске с 1 июня по 1 июля цена будет равна `30 * 1000 = 30000 RUB`.

Тариф для 2 взрослых гостей с заездом 1 мая и выездом 3 мая:
```json
{
    "conditions": {
        "dates": [
            {
                "min": "2022-05-01",
                "max": "2022-05-02"
            }
        ],
        "days": 2,
        "occupancy": {
            "adults": 2
        }
    },
    "rate": {
        "amount": "1000",
        "currency": "RUB"
    }
}
```
Цена будет равна `2 * 1000 = 2000 RUB`. Для выезда 3 мая нужно указывать `"max": "2022-05-02"` так как сутки выезда не считаются.

Тариф для 2 взрослых и 2 детей 3 и 4 лет до 3 суток в рабочие дни:
```json
{
    "conditions": {
        "dates": [
            {
                "min": "2022-05-01",
                "max": "2022-10-01"
            }
        ],
        "occupancy": {
            "adults": 2,
            "childrenAges": [3, 4]
        },
        "days": {
            "max": 3
        },
        "weekdays": [
            "mon",
            "tue",
            "wed",
            "thu",
            "fri"
        ]
    },
    "rate": {
        "amount": "1000",
        "currency": "RUB"
    }
}
```
При поиске с 1 июня по 4 июня цена будет равна `3 * 1000 = 3000 RUB`.

После бронирования этого номера с 1 июня по 4 июня, эти даты надо будет исключить из списка доступных:
```json
{
    "conditions": {
        "dates": [
            {
                "min": "2022-05-01",
                "max": "2022-05-31"
            },
            {
                "min": "2022-06-04",
                "max": "2022-10-01"
            }
        ],
        "occupancy": {
            "adults": 2,
            "childrenAges": [3, 4]
        },
        "days": {
            "max": 3
        },
        "weekdays": [
            "mon",
            "tue",
            "wed",
            "thu",
            "fri"
        ]
    },
    "rate": {
        "amount": "1000",
        "currency": "RUB"
    }
}
```

Даты можно смешивать с диапазонами:
```json
{
    "conditions": {
        "dates": [
            {
                "min": "2022-05-01",
                "max": "2022-05-05"
            },
            "2022-05-15",
            "2022-05-21"
        ],
        "occupancy": {
            "adults": 2
        }
    },
    "rate": {
        "amount": "1000",
        "currency": "RUB"
    }
}
```

## Группировка тарифов {#tariffGroups}

Сезонные тарифы. Летом цена 5000 ₽ в сутки, осенью 3000 ₽ в сутки:
```json
[
    {
        "id": "season_tariff",
        "groupId": "compatible_tariffs_id",
        "conditions": {
            "dates": {
                "min": "2022-06-01",
                "max": "2022-08-31"
            },
            "days": 5,
            "occupancy": {
                "adults": 2
            }
        },
        "rate": {
            "amount": "5000",
            "currency": "RUB"
        }
    },
    {
        "id": "off_season_tariff",
        "groupId": "compatible_tariffs_id",
        "conditions": {
            "dates": {
                "min": "2022-09-01",
                "max": "2022-11-31"
            },
            "days": 5,
            "occupancy": {
                "adults": 2
            }
        },
        "rate": {
            "amount": "3000",
            "currency": "RUB"
        }
    }
]
```

При поиске с 29 августа по 3 сентября цена будет `3 * 5000 + 2 * 3000 = 21000 RUB`. Тарифы объединятся благодаря одинаковому значению `groupId`.

Параметры ссылки на бронирование будут:
```
?token=123e4567e89b12d3a456426614174000&checkIn=2022-08-29&checkOut=2022-09-03&adults=2&tariffs.groupId=compatible_tariffs_id&tariffs.id=season_tariff&tariffs.id=off_season_tariff&tariffs.switchDate=2022-09-01
```
