---
title: WhiteLabel отелей бронируемых по схеме BoY (апрель 2022)
---
## Продуктовые требования
Для каждого партнера создаются домен вида https://{partner}-travel.yandex.ru .
На этом сайте, есть формы поиска и бронирования проживания в отелях (потенциально и другие разделы путешествий). Сайт стилизован под корпоротивный дизайн партнера.

### Шаги бизнес процесса
1. Переход с сайта партнера сохранения в сеансе ID перехода, ID пользователя, возможно другой пользовательских данных, например номер телефона пользователя.
   * https://{partner}-travel.yandex.ru должен вести независимые от https://travel.yandex.ru партнерские программы и учет переходов покупателей.
   * Бекэнд должен корректно логгировать ID перехода и ID пользователя
   * Бекэнд должен корректно связывать заказы с ID перехода и ID пользователя
   * Бекэнд должен корректно формировать метрики, в том числе метрики воронки для партнера
2. Модификация поиска и пред заказа
   * Изменить расчет бонусов и (или) кэш-беков
   * Другой набор акций, некторые акции доступны для whitelabel например пользование картой МИР, а другии нет например реклама ROOMS
   * Выдавать только отели для которых доступно бронирования по схеме BOY (бронирование и олпата на yandex travel)
3. Добавление полей в структуру заказа и редактирования соответствующих компонентов
   * Признак формирования заказа на странице Whitelabel партнера, информации о бонусах партнера, специфические данные партнера, напимер номер бонусной программы.
   * Риск: мы неправильно насчитали бонусы партнера. Как минимизировать этот риск?
   * Изменение: формирование заказа, список заказов, страница заказа, админка службы эксплуатации.
   * Отдельный вопрос как оповещаем S7, если покупатель попросил изменить номер карты в программе лоялности
4. Расчеты с партнерами
   * Метрики воронки
   * Отчеты для начисления бонусов покупателям
   * Платежи партнерам

### Границы текущего шага
* Приоритизация отелей такая же как и на https://travel.yandex.ru.
* SEO страницы на доменах WhiteLabel не нужны.
* На страницах WhiteLabel доступны только отели бронируемые по схеме BoY (book on Yandex)


### 1. Связь покупателя с сайтом партнера
Теоретически все делается на фронте, но есть риск серьезной протечки на серверную часть.

**Открытые вопросы:**
1. Какие поля описывающии пользователя можем получать от партнера? Достаточно ли  и P
    * `PartnerRequestUID` - идентификатор перехода
    * `PartnerUserUID` - идентификатор покупателя
2. Могут ли партнеры добавлять специфические параметры?

### Открытые вопросы
1. Нужны ли сейчас акции на доменах WhiteLabel?
2. Делаем ли для S7 возможность выбора бонусной программы мили S7 или Yandex+?
3. Какие параметры получаем при переходе с сайта партнера? (`PartnerRequestUID`, `PartnerUserUID`)
4. Когда и как мы передаем партнерам информацию об бронировании на WhiteLabel?
5. Что мы отдаем в виде метрик воронки для партнеров?
6. Как мы отдаем в виде метрик воронки для партнеров?
7. Как мы должны осуществлять переводы денег партнеру?

## Технические требования
### 1. Связь покупателя с сайтом партнера
Теоретически все делается на фронте, но есть риск серьезной протечки на серверную часть.

**Риски:**
1. Переходы на WhiteLabel меняет данные о последнем переходе на travel.yandex.ru или
   другого партнера по WhiteLabel.
2. Во логах должны сохраниться `PartnerRequestUID` и `PartnerUserUID`.

**Открытые вопросы:**
1. Какой список компонент на регрес?

### 2. Поиск и предзаказ
**Компоненты:** (`travel-api`)[https://a.yandex-team.ru/arc_vcs/travel/api]

**Используем, но не трогаем:** `offer-cache`

**Методы  (`travel-api`)[https://a.yandex-team.ru/arc_vcs/travel/api]:**
* поиск отелей - GET `/api/hotels_portal/v1/search_hotels`
* получение предложений - GET `/api/hotels_portal/v1/get_hotel_offers`
* заказ по токену - GET `/api/booking_flow/v1/get_order_info_by_token`
* заказ со скидкой - GET `/api/booking_flow/v1/estimate_discount`

**Концепция**

Добавляем в запросы три поля: `WhiteLabelParentId`, `WhiteLabelRequestUID`, `WhiteLabelUserUID`.
И заменяем вычисление балов Yandex+ бонусы партнера.

**Замечание по response**
В поиске отелей (`/api/hotels_portal/v1/search_hotels`) и получение предложений (`/api/hotels_portal/v1/get_hotel_offers`)
возвращаем данные о бонусах в той же структуре, что и бонусы Yandex+ (`Badge`).

В заказе по токену (`/api/booking_flow/v1/get_order_info_by_token`)
и заказе со скидкой (`/api/booking_flow/v1/estimate_discount`)
не переведены на структуру `Badge`, поэтому делаем дополнительные поля.
Эти методы унифицируем до момента слияния.

**Замечание по поиску**

Сделать возможность отключения Click-Out провайдеров в зависимости от партенера WhiteList.

**Границы:**
1. Приоритизация поиска остаются такой же, как и для https://travel.yandex.ru .

**Открытые функциональные вопросы:**
1. Правильно ли я понимаю, что отели бронируемые у партнеров нужно отфильтровать?

   Да. Пока в этом документе не расматриваем click-out.

**Открытые архитектурные вопросы:**
1. Уточнить изменяемы методы?
2. Какие еще компоненты есть в процессе?
3. Как реализуем методы поиска предзаказа есть два варианта?
   * ~~Скопировать методы и внести правки.~~
     ~~Плюс решения соблюдаем принцип разделения интерфейса (I in SOLID). Минус вроде как сложнее.~~
   * <ins>альтернатива редактировать имеющиеся методы</ins>.

### 3. Изменение заказа
**Компоненты:** (`travel-api`)[https://a.yandex-team.ru/arc_vcs/travel/api], оркестратор заказов.

**Методы  (`travel-api`)[https://a.yandex-team.ru/arc_vcs/travel/api]:**
* бронирования заказа - POST `/api/booking_flow/v1/create_order`
* получения заказа - GET `/api/booking_flow/v1/get_order`

**Концепция**
В метод бронирования заказа (POST `/api/booking_flow/v1/create_order`) добавляем поля
`WhiteLabelParentId`, `WhiteLabelRequestUID`, `WhiteLabelUserUID`, дополнительные данные,
карты лояльности и обещанные за заказ бонусы. Соответственно в получении заказа добавить
все добавленные поля.

**Расширение
TODO описать расширения структуры заказа.

**Риск:**
1. Неправильно указано количество бонусов? Как страховать этот риск:
   * параноидально, дергать апи партнера на странице бронирования
   * анализ статистики по забронированным заказам

**TODO:**
1. Разобрать структура хранения заказа отелей, подготовить расширения ее.

### 3.1. Изменение заказа

### 4. Расчеты с партнерами

**Компоненты**:
* https://a.yandex-team.ru/arc/trunk/arcadia/travel/external_api


#### Передача данных о бронировании
**Компонент:** [`travel/external_api`](https://a.yandex-team.ru/arc/trunk/arcadia/travel/external_api)

**path:** `whitelabel/get_orders`

**Возвращаемые поля**:
* `orderId` - идентификатор заказа у нас
* `partnerRequestUID` - идентификатор перехода с сайта партнера
* `partnerUserUID` - идентификатор покупателя в системе партнера
* `status` - текущий статус заказа
* `updateCount` - количество обновлений
* `updateDatetime` - последнее обновление статуса заказа
* `createDatetime` - дата и время бронирования (?)
* `checkinDate` - дата заезда (?)
* `checkoutDate` - дата выезда
* `orderAmount` - сумма заказа
* `bonusAmount` - бонусы обещанные покупателю
* `feeAmount` - сумма перечисляемую партнеру
* `partnerCustomerNumber` - идентификатор покупателя в программе лояльности партнера

**Статусы заказа**
TODO уточнить статусы заказов
* `BOOKED` - забронирован
* `CHECKOUTED` - гость своевременно выехал
* `EARLY_CHECKOUTED` - ранний выезда
* `CANCELLED` - отменен
* `SUPPORT_EDITED` - изменен службой поддержки


**Фильтрация**
* `updateDatetime` - интервал последненго обновления заказа

#### Открытые вопросы:
**Функциональные вопросы**
1. Когда и как мы передаем партнерам информацию об бронировании на WhiteLabel?

   предложение в "Передача данных о бронировании"

2. Что делать в случаи раннего выезда?

3. Что делать при редактировании заказа службой поддержки?

4. Что и как мы отдаем в виде метрик воронки для партнеров?

   вне границ текущего этапа.

5. Как мы должны осуществлять переводы денег партнеру?

   вне границ текущего этапа.

**Архитектурные вопросы**
1. Как проводим аутентификацию партнеров для вызова external_api?

**TODO**
1. Уточнить статусную модель отельных заказов.

### 5. Редактирование заказа в админке
Реализовать возможность редактирования заказа в админке.
При сменах дат заезда и выезда корректно пересчитывать сумму возможных бонусов.

### 6. Перевод в статусы позволяющие начислять бонусы
Какие критерии перевода заказа в статусы заказа в статус `CHECKOUTED` и `EARLY_CHECKOUTED`?

