---
title: Seo-страницы поездов
---

# Seo-страницы поездов


## Высокоуровневый дизайн.

Схема взаимодействия: 
TravelFront --> travel-api --> trains-search-api

Шаблоны и тестовые константы храним в танкере для возможности быстро править их + переводы + плюральные формы.

Из танкера поездовые кейсеты выгружаем в s3 sandbox-таском. trains-search-api загружает кейсеты из s3 для надежности.
Все необходимые для seo-страниц данные есть в trains-search-api, применяя их к шаблону trains-search-api генерирует ответ максимально близкий по формату к тому, что ожидает фронт, а travel-api преобразует proto в json для фронта.

[Страница направления: спека фронта](https://github.yandex-team.ru/data-ui/ya-travel-spec/pull/262/files)

### Данные в танкере

1) константа типа "фирменный поезд", "завтра" (можно выделить в отдельный keyset trains.constants)
2) текстовый шаблон в формате Jinja/Django
3) json в формате ответа для фронта, вместо текстов содержит ключи текстовых шаблонов

### sandbox-таск TRAINS_SEO_TANKER_TO_S3

1) Валидирует схему json на соответствие формату фронта
2) Тесты шаблонов? Можно попробовать так: статичные данные для страницы в json храним в танкере + статичный ответ, который должен получиться в результате. Применяем данные к шаблону, сравниваем результат. Как удобно вывести diff?
3) Дампим танкер в s3 при помощи [resourcestorage](https://a.yandex-team.ru/arc_vcs/travel/library/go/resourcestorage/)

### search-api

1) загружает шаблоны из s3, проверяет в фоне версию раз в 5 мин, перечитывает если новая
2) в обработчике собираем данные: считает статистику на лету по кешу тарифов + справочники расисаний уже в памяти + шаблоны загружены
3) применяем данные к шаблону Jinja
4) отдаем ответ

Для Jinja шаблонов используем [pongo2](https://a.yandex-team.ru/arc/trunk/arcadia/vendor/github.com/flosch/pongo2)

### travel-api

перекладыает proto-структуры search-api в формате фронта

## Редактирование проверка и выкатка шаблона:

1) правим шаблон(ы) в танкере в ветке [trains-testing](https://tanker.yandex-team.ru/project/travel-backend?branch=trains-testing)
2) запускаем таск TRAINS_SEO_TANKER_TO_S3 на тестовом окружении, смотрим что он выполнился успешно, значит валидация прошла (правим тесты в танкере, если мы их реализуем)
3) ждем 5 минут, пока search-api перечитвает шаблоны
4) шаблоны в тестинге, ходим по seo-страничкам, любуемся результатом
5) если в тестинге все ок, то в танкере мержим ветку trains-testing в master
6) запускаем TRAINS_SEO_TANKER_TO_S3 на проде, либо ждем пока он сам выполнится по расписанию
7) ждем 5 мин search-api
8) шаблоны в проде, можем проверить и там

## Failure modes

**отказ танкера**: не можем редактировать и катать новые шаблоны, seo-страницы работают

**отказ sandbox**: можем редактировать шабоны, не можем катать шаблоны, seo-страницы работают

**отказ s3**: можем редактировать шабоны, не можем катать шаблоны, seo-страницы работают только до рестарта search-api

**отказ search-api или travel-api или фронт**: seo-страницы не работают


## Планы на развитие

### Добавить html-теги 

Для поддержки ссылок и выделения слов в тексте добавляем в шаблоны html-теги:
- \<a href="">
- \<b>
- \<i>

В search-api при чтении шаблонов парсим html-теги, добавляем соответствующие TextBlock для фронта.
Можно использовать [goquery](https://a.yandex-team.ru/arc/trunk/arcadia/vendor/github.com/PuerkitoBio/goquery) для парсинга html на go.
