---
title: Новый ЖД + ЖД колдун
---
# Пересадки в ЖД колдунщике

## Формализованные продуктовые требования.

Необходимо возвращать варианты с пересадками. Тем самым увеличиваем трафик на сервис с ОТК

Предложения показанные в визарде должны быть доступны на портале.

## Технические требования

Требования к времени ответа Q99 - 50ms

## Высокоуровневый дизайн.

Код живет в TrainsSearchAPI, является частью нового ЖД визарда.

Схема взаимодействия:

- TrainsSearchAPI -> pathfinder (новый клиент)
- TrainsSearchAPI <-> logbroker (автобусный логброкерный клиент)
- TrainsSearchAPI -> mds-s3 (автобусная s3 снапшотилка)

Логика работы:
- Ищем в тарифах прямые варианты (сейчас из базы, потом из inmem кеша)
- Иначе ищем в кеше пересадок
- Иначе синхронно отправляет запрос в пересадочник с ограничением времени ответа в 50ms. В фоне делаем долгий запрос в пересадочник, ответ отправляем в ЛБ
- ЛБ косюньмеры обновляют кеш пересадок
- Найденные пересадки обмазываются сегментами (сейчас из базы, потом из inmem кеша)

API:
- Расширение апи визарда

## Failure modes

- В случае отказа pathfinder'a живем на пересадочном кеше - плавно деградируют пересадочные варианты.
- В случае ошибки записи в ЛБ отвечаем по пересадочному кешу и синхронным быстрым запросам в пересадочник - плавно деградируют пересадочные варианты.
- В случае ошибки чтения из ЛБ начнется рассинхронизация ответов между инстанстами. Необходим алерт на рассинхрон кешей и чтение из очереди.
- В случае ошибки доступа в s3 - свежезапущенный сервис будет подниматься дольше из очереди ЛБ (10+ минут). Деградация качества выдачи не предполагается.

## Метрики

- Матрики кеша пересадок: записей, статусы
- Метрики запросов: промахи/попадания в кеш тарифов и пересадок в разрезе числа сегментов (квантили)
- Метрики ответов/неответов пересадочника в синхронном и фоновых режимах
- Метрики ответов визарда (найдено, не найдено, число вариантов в разрезе числа сегментов)
- Алерт на расхождение числа записей в кеше между инстансами


## План выкатки в production

- Выкатываем фронт
- Выкатываем TrainsSearchAPI
- Включаем под экспериментом
- Убираем эксперимент из кода TrainsSearchAPI
