---
title: Общее описание
rank: 10
---

### Общее описание

Администратор — сервис управления подключением отелей.

Основные сущности с которыми работает администратор:
- Подключение отеля (`HotelConnection`)
- Юридические данные с банковскими реквизитами (`LegalDetails`) - на одних `LegalDetails` могут быть несколько Подключений отеля  
- Регистрация в Балансе (`BillingRegistration`) - связана с `LegalDetails` one-to-one используется для оркестрации процесса регистрации и обновления юр. данных в балансе  
- Шаг подключения отеля (`HotelConnectionStep`, его наследники `CallGeoSearchStep` и `VerifyClusteringStep`) - отвечает за выполнения конкретного действия, необходимого при подключении отеля
- Заявка на обновление `HotelConnection` (`HotelConnectionUpdate`) - содержит в себе всю информацию, необходимую для применения некоторых изменений к `HotelConnection`, в том числе и возможную смену реквизитов  
- Апдейт `LegalDetails` (`LegalDetailsUpdate`) - содержит в себе всю информацию для обновления юр. данных

Основная задача Администратора быть source of truth информации по подключению отелей, а именно, подключен отель или нет и на каких конкретно реквизитах, с какими айдишниками в Балансе и с какими комиссионными схемами.  
Далее вся эта информация публикуется в YT таблицах для использования в таких компонентах, как Оркестратор, Офферкеш и др.  
Концептуально Администратор синхронизирует свое состояние с состоянием у партнера (Travelline, Bnovo, etc.), получая от партнера нотификации на Внешнее АПИ и запрашивая данные у партнера после этого.  

### Техническое

С архитектурной точки зрения Администратор похож на Оркестратор и представляет из себе standalone java Spring Boot приложение, взаимодействующее с базой данных (postgresql). 
Приложение Администратора можно поделить на две крупные части:
1. GRPC сервисы для взаимодействия с внешним миром
2. Workflow handler-ы, зарегистрированные для работы с workflow сущностей администратора и TaskProcessor-ы, обрабатывающие фоновые задачи, связанные с сущностями.

GRPC сервисы, workflow handler-ы и taskProcessor-ы используют для своей работы сущности (entities), сервисы (services), содержащие функционал и бизнес-логику и repository - вспомогательные сервисы для получения сущностей из базы данных.

### Миграции базы данных

Механизм миграции идентичен [Механизму миграции Оркестратора](../orders/tx_migrations)  
Для миграции использовать [Утилиту для Администратора](https://a.yandex-team.ru/arc/trunk/arcadia/travel/hotels/hotels_administrator/tools/db_migrator)

### Вспомогательные утилиты

Помимо утилиты для миграции есть еще:  
[Утилита для ручного подключения отелей](https://a.yandex-team.ru/arc/trunk/arcadia/travel/hotels/hotels_administrator/tools/manual_connection_tool) - на данный момент используется только для подключения отелей на "бумажных договорах". Более полную инструкцию можно получить на [Дашборде ручного подключения отелей](https://st.yandex-team.ru/dashboard/32967#154477)  
[CLI администратора](https://a.yandex-team.ru/arc/trunk/arcadia/travel/hotels/hotels_administrator/tools/administrator_cli)  