---
title: Описание Travel-API
rank: 10
---

### О Travel-API

Travel-API решает задачу интеграции и адаптации источников к запросам интерфейсов (будь то текущий фронт тревел-портала, возможные админки или будущие мобильные приложения). Задача содержательная, потому что всегда есть несостыковки между продуктовыми требованиями к человеческим интерфейсам и техническими интерфейсами нижележащих систем. Примеры:
 - в странице "Спасибо за заказ" планируются блоки со ссылками на другие сервисы / рекламные промоушены; где-то должна храниться и отдаваться информация об этих блоках;
 - для кросс-продаж полезно в страницу отельных заказов встраивать элементы для поиска авиа-билетов и ж/д-билетов; где-то должна быть логика вычисления параметров запросов (и, вероятно, запроса) к системам авиа и ж/д по данным отеля (или "как вычислить station_id по permalink");
 - для флоу бронирования отелей и для флоу бронирования ж/д необходимо взаимодействовать с сервисом заказов (Оркестратор) и с системами отелей / поездов для получения доменной информации;

Из анти-примеров: объемная и сложная реализация продуктовой функциональности; к примеру:
 - приём денег и оказание услуг в рамках работы над заказом Путешествий;
 - поиск цен на отели / авиа-билеты / поезда;

Формально и точно провести границу, где заканчивается "интеграция и адаптация" и начинается "объемная и сложная продуктовая функциональность", не представляется возможным: это всегда компромисс и предмет для диалога. При этом есть некоторые полезные эвристики:
 - у нижележащих систем обычно есть более стабильная и внятно определенная модель данных и семантика операций над ними;
 - у нижележащих систем обычно более четко определены пре/пост-условия, инварианты и другого рода предоставляемые гарантии;
 - Travel-API отстраивается от нужд продукта и интерфейса в первую очередь;
 - Travel-API "собирает джисоны";
 - Travel-API не обладает ценным, персистентным состоянием.

Кроме продуктовых задач, Travel-API может решать ряд технических задач: форсирование аутентификации; ограничение RPS; изоляция отказов.

Наиболее близкие buzzwords к роли Travel API -- middleware, api gateway.

## Разработка Travel API

### Travel API - монолитное Java-приложение

Для удобства и скорости разработки: в рамках одного приложения сильно проще переиспользовать код, данные (словари). Система типов помогает быстрее вносить изменения и экономить на тривиальных тестах за счет базовой type-soundness. Страхи "сломать код соседа", "не смочь выкатить оперативно хот-фикс" решаются ограничением роли Travel-API и гайдлайнами по разработке.

### Внешние (потребляемые) методы API соответствуют интерфейсным страницам и действиям (не-REST)

REST API хорош для технического интерфейса системы, но не для человеческого. Потому что всегда будут задачи "а вот на эту страницу давайте еще добавим ...". Обойдемся без идеологических споров: методы API предоставляют данные для человеческих интерфейсов и обслуживают человеческие действия.

### Внешние (потребляемые) методы API оперируют изолированной моделью данных

В технических терминах -- отдельные POJO для запросов и для ответов, которые (идеально) не используются в нижележащих системах. Такое разделение помогает изолировать и разделить внутренние изменения протокола и внешние изменения протокола (влияющие, к примеру, на разработку фронтенда).

### Органиция URL-ов: /api/ГРУППА/ВЕРСИЯ_МЕТОДА/МЕТОД

Для удобства удобно группировать методы. Группировка обычно функциональная. Группы расположены плоско: для простоты договоренностей. Версионирование ведется на уровне каждого отдельного метода.

#### Пример 1 (группа "orders")
Набор методов для личного кабинета. Можно было бы назвать "my_orders" для понятности.

```
/api/orders/v1/check_authorization
/api/orders/v1/list_orders
/api/orders/v1/list_orders_next_page
/api/orders/v1/request_authorization
```

#### Пример 2 (группа "booking_flow") 
Набор методов для флоу бронирования отелей. Можно улучшить, переименовав пакет в hotels_booking_flow, чтобы поделить методы для флоу бронирования разных вертикалей.

```
/api/booking_flow/v1/calculate_refund
/api/booking_flow/v1/check_authorization
/api/booking_flow/v1/create_order
/api/booking_flow/v1/get_order
/api/booking_flow/v1/get_order_info_by_token
/api/booking_flow/v1/get_order_pdf_link
/api/booking_flow/v1/list_orders
/api/booking_flow/v1/request_authorization
/api/booking_flow/v1/start_payment
/api/booking_flow/v1/start_refund
```

### Организация контроллеров

Так как контроллер жестко провязывает URL, модель запроса и модель ответа, то предлагается контроллер держать максимально легким и асинхронным. Примерно таким:

Легковесная валидация, маппинг параметров на req/rsp-объекты, deferred results

```Java
@RestController
@RequestMapping(value = "/api/the_group")
@RequiredArgsConstructor
class TheGroupController {
  private final TheGroupImpl impl;

  @RequestMapping(value = "/v1/method_a", method = GET)
  public DeferredResult<MethodARspV1> methodA_v1(
    @RequestParam(name = "arg1") T1 a1,
    @RequestParam(name = "arg2") T2 a2, ...)
  {
    // may validate a1, a2 if necessary
    return controllerHelpers.replyWithFuture(impl.methodA(req));
  }
  
  // Со структурой-запросом:
  @RequestMapping(value = "/v1/method_b", method = GET)
  public DeferredResult<MethodBRspV1> methodA_v1(@Validated MethodBReqV1 req) {
    // may validate a1, a2 if necessary
    return controllerHelpers.replyWithFuture(impl.methodB(req));
  }

}

@Component
class TheGroupImpl {
  CompletableFuture<MethodARspV1> methodA(MethodAReqV1 req) { ... }
  CompletableFuture<MethodBRspV1> methodA(MethodBReqV1 req) { ... }
}
```

Что здесь важно:
- контроллеры у нас non-blocking: комбинация deferred result + completable future;
- возвращаемые значения обернуты в deferred result: это позволит корректный fault isolation сделать в следующей версии;
- имплементация оперирует completable future: это делает более простой композицию кода в имплементациях;
- сопряжение deferred result <> completable future реализованно шаблонным образом и один раз: защищает от типичного бага с потерей исключения;
- суффиксы Req/Rsp кодируют в названии, к чему относится структура: к запросу или к ответу;

Рекомендации в этом пункте будут уточняться по мере приобретения опыта миграции на новую структуру.

### Организация кода: 1 Java-пакет на 1 группу URL-ов с контроллером, реализацией и моделями

Код Travel API находится в $A/travel/api. А дальше внутри примерно так:

```
src/main/java/ru/yandex/travel/api/
  /services/ -- здесь живет функциональность;  не рассматривается в данном письме;
    /hotels/ -- отельно-специфичный код;
    /orders/ -- заказно-специфичный код;
    ...
  /models/ -- здесь живут модели, использующиеся в запросах и ответах API, кроме(!) самих Req и Rsp моделей.
    /common/ - общие модели (цены, языки, ...)
    /hotels/ - модельки отельные
    ...
  /config/ -- конфигурация (в смысле spring configurations; для провязывания бинов);
  /endpoints/ -- здесь живет код http-слоя; не controllers, чтобы отслеживать процесс перехода;
    /the_group/
      /req_rsp/ - модели запросов-ответов каждой ручки
        MethodAReqV1.java - запрос метода А
        MethodARspV1.java - ответ метода А
        MethodBReqV1.java - запрос метода Б
        MethodBRspV1.java - ответ метода Б
      TheGroupController.java
      TheGroupImpl.java
    /orders/
      /req_rsp/
        ListOrdersReqV1.java
        ListOrdersRspV1.java
      OrdersController.java
      OrdersImpl.java
```

Рекомендации в этом пункте будут уточняться по мере приобретения опыта миграции на новую структуру.

## HealthCheck
HealthCheck используется системой деплоя (Няня) для того, чтобы определить момент, когда инстанс готов и можно выкатывать следующий.

Балансер также смотрит на healthcheck, и посылает запросы только на те инстансы, которые считают себя живыми.

Чтобы няня не выключила одновременно слишком много инстансов, а балансер не лил трафик на выключенные/поднимающиеся инстансы, используется healthcheck. 

Если весь инстанс считает себя живым, но какая-то ручка не готова обслужить текущий запрос, 
то допустимо вернуть ошибку 5xx, балансер перепошлёт запрос на другой инстанс. Так формируются независимые failure domains по ручкам.
Однако, если можно предсказать, что ручка не будет способна обслуживать запросы и далее, то это повод вынести это знание в healthcheck, но с учетом правил (см. ниже).

Таким образом, healthcheck-и нужны для того, чтобы не оказаться в ситуации, когда в процессе выкатки все инстансы 
(или их существенная доля) приложения не способны обслужить запрос.

Так как приложение монолитное, то нельзя вносить в healthcheck всё подряд, иначе поднятие будет происходить слишком долго, 
а закрываться от балансера приложение будет слишком часто. 

Поэтому существуют такие 


**Правила внесения в healthcheck**:
1. В healthcheck можно вносить только то, без чего работа какой-либо ручки невозможна.
2. В healthcheck нельзя вносить то, для чего есть механизм плавной деградации во фронтэнде.
3. В healthcheck нельзя вносить чисто сетевые зависимости (зависимость, которая необходима для старта приложения, но может быть недоступна по сети. Хорошим примеро, как стоит поступать с такими зависимостями является YtLuceneIndex, который держит локальный кэш данных, прочитанных из YT, и при рестарте инстанса и недоступности YT не будет мешать старту приложения). Исключением из этого правила служит TVM, который можно отнести к общесистемным сервисам (e.g. TVM, DNS).
4. Для каждой проверки, вынесенной в healthcheck, в конфиге должен быть предусмотрен флаг, отключающий проверку. Эта дает необходимую гибкость для экстренных случаев, когда какая-то часть непоправимо сломалась, но катиться нужно.


**Примеры, что должно быть в healthcheck**:
* Проверка готовности словаря slug-ов отелей, т.к. без него ручки портала отелей не работают, и фронтэнд ничего с этим поделать не может. 
При этом, хотя словарь является сетевой зависимостью (грузится из YT), но эта зависимость не чистая, т.к. есть локальный кэш.

**Примеры того, чего не должно быть в healthcheck**: 
* Хранилище офферов. Потому что, во-первых, является чисто сетевой зависимостью, а во вторых фронт умеет показать 
страничку "ой, извините, поищите лучше отели тут".
* Оркестратор. Причины аналогичны.
 

## Тестирование Travel-API

### Инфраструктурная функциональность должна быть покрыта юнит-тестами

Инфраструктурная = общая для всех методов. К примеру, перехват и контекстуализация информации о пользователе (user-ticket + yuid + pid + login). К примеру, проверка и валидация TVM-заголовков. К примеру, перехват и контекстуализация трассировочной информации.

### Юнит-тесты на перекладывание джисонов можно не писать

Пустая трата времени.

### Репликация GET-запросов на тестовый контур

В качестве важного механизма тестирования планируем организовать репликацию GET-запросов на тестовый контур. Возможно, дополнив во второй итерации репликацией запросов за вчера/позавчера/... . Критерием работоспособности является отсутствие 500-к.
