---
title: Обработка ошибок
rank: 40
---

## Обработка ошибок
Spring boot приложение может поднимать из коробки приложение Spring mvc.
В приложении по умолчанию поднято много хороших дефолтов. Среди них, удобный дефолт по обработке ошибок. 

Для того, чтобы у нас была однородная обработка ошибок предлагается следующее:
 
### Специфичный код ответа
Если необходимо в контроллере вернуть специфичный статус при возникновении ошибки, из сервиса выкидывается ошибка, определенная в API, при этом на нее навешивается аннотация `@ResponseStatus`, в которой можно указать причину и код ответа.

Чтобы вернуть 400 Bad Request своё исключение заводить не нужно, уже есть общее - `TravelApiBadRequestException`. Также есть метод `TravelPreconditions.checkRequestArgument`, который отличается от `Preconditions.checkArgument` как раз типом исключения.

Не стоит использовать `IllegalArgumentException` для этих целей, т.к. он может быть выброшен в неожиданном для вас месте, породив таким образом 400 там, где должна быть 500. Например, такое исключение может быть выброшено из `String::format`.
Тем не менее, на данный момент во многих контроллерах `IllegalArgumentException` всё ещё используется для возврата 400 кода. Надо стараться от этого уходить и удалять соответствующие ExceptionHandler-ы.


### Более кастомная обработка ошибки 
Eсли необходимо как-то расширенно обрабатывать исключение (кастомизировать возвращаемый ответ и т.д.), то необходимо использовать метод контроллера со специальной аннотацией `@ExceptionHandler` (там возможности по кастомизации логики обработки исключений богаты и стоит обращаться к документации)

Eсть так же `@ControllerAdvice`, в котором для grpc `StatusRuntimeException` объявлен метод с аннотацией `@ExceptionHandler`

### Про обработку ошибок в тестах
 
В тестах на контроллеры с использованием `MockMvc`, при проверке исключительного поведения и работает с `CompletableFuture`, необходимо возвращать `CompletableFuture.failedFuture()` с настоящим исключением, которое бросается в этом сервисе (для grpc это будет `StatusRuntimeException`). Если там выкидывать просто `RuntimeException`, то моковый сервлет его не обработает, так как в моковом сервлете не регистрируется дефолтовый `ErrorController`


