## Компоненты

* collector(aka Persister) -- монолитное Go-приложение, в том плане, что забор данных из новых источников впиливается сюда же и увеличивает компонент. Collector занимается тем, что забирает данные из N источников, складывает в БД и отправляет сообщение в очередь user-events
* api -- отдельное приложение, для возможности масштабировать и настраивать независимо от collector
* user-events -- topic в logbroker

Основной базой данных выбрана YDB

[production](https://ydb.yandex-team.ru/db/ydb-ru/travel/production/personalization/browser)
[testing](https://ydb.yandex-team.ru/db/ydb-ru-prestable/travel/testing/personalization/browser)

#### UserHistory API

Тонкий слой, ответственный за интеграцию с внешними системами.
Предоставляет говорящие методы для различных сценариев использования.

GRPC-сервер. Фронт ходит через HTTP с проксированием через travel-api

Ожидаемые потребители:
*  Авиа в портале: https://github.yandex-team.ru/data-ui/ya-travel-spec/tree/master/avia/personalization
*  Авиа Колдун
*  Отели в Портале
*  Отели Колдун

##### Методы

| Метод | Описание |
|-------|---------|
| [`GetPersonalSearch`](https://arcanum.yandex-team.ru/arc/trunk/arcadia/travel/avia/personalization/api/personalsearch_service.proto)| Метод для получения списка последних поисков |

#### Persister

Логика простая:
1) Читаем сообщение
2) Пишем в БД
3) Пишем в user-events
4) Подтверждаем сообщение

Основное требование - не терять события пользователей чтоб не показывать неожиданную фигню


Логически persister/processor состоит из двух сущностей: `Collector` и `Data Access Layer`.
В теории между Collector и DAL может быть помещена events queue, тогда эти две сущности превратятся в раздельные сервисы и появится возможность интегрировать других потребителей через events queue, но на данном этапе это является overengeniering'ом.

##### Collector

Обработчик данных для различных источников.
Преобразует получаемый поток данных в формат, удобный для храненияв БД

Сейчас 2 источника данных:
- Logbroker avia-users-search-log https://lb.yandex-team.ru/logbroker/accounts/rasp-front/avia-users-search-log
- Logbroker avia-wizard-query-log https://lb.yandex-team.ru/logbroker/accounts/rasp-front/avia-wizard-query-log

Читатели для очередей в каждом из 5 ДЦ (IVA, MAN, SAS, VLA, MYT), т.к. LB в мультикластерном режиме для основных логов

##### Events queue

Между Collector и Persister могла бы существовать дополнительная шина, но с ней сложнее было бы гарантировать подтверждение сохраненных сообщений и пока отказываемся от нее

##### Data Access Layer

Реализует логику сохранения актуальных данных в БД

Текущая схема:
```--!syntax_v1
CREATE TABLE personalization
(
    yandexuid Uint64, -- yandexuid пользователя
    service Uint8, -- id из Enum-а вертикалей Я.Путешествий. Сейчас просто 2 константы Авиа=1 Отели=2
    createdAt Uint32, -- время, в которое произошло событие
    mainReqid Utf8, -- идентификатор поиска на колдунщиках, по сути ID 1 сессии поиска на серпе. Планировали записывать в базу для авиа только 1 запись с максимальным createdAt по одному mainReqid(Пока не реализовали)
    event Utf8, -- JSON с описанием пользовательского события

    PRIMARY KEY (yandexuid, service, createdAt)
);
```
Договаривались добавить как минимум event_type (search/order) service остается Enum источников событий
```--!syntax_v1
CREATE TABLE personalization
(
    yandexuid Uint64, -- yandexuid пользователя
    passportid Uint64, -- passportid пользователя
    service Uint8, -- id из Enum-а вертикалей Я.Путешествий. Сейчас просто 2 константы Авиа=1 Отели=2
    eventType Uint8, -- пока 2 типа search/order, могли бы быть uint8 из Enum-а типов событий
    createdAt Uint32, -- время, в которое произошло событие
    mainReqid Utf8, -- идентификатор поиска на колдунщиках, по сути ID 1 сессии поиска на серпе. Планировали записывать в базу для авиа только 1 запись с максимальным createdAt по одному mainReqid(Пока не реализовали)
    event Utf8, -- JSON с описанием пользовательского события

    PRIMARY KEY (yandexuid, passportid, service, eventType, createdAt)
);
```

## Взаимодействие с потребителями

### Портал/Авиа-колдун

Получают данные путем синхронного вызова метода "GetPersonalSearch".

### Отельные колдуны

Требования к времени ответа на колдунах отелей выше, поэтому используется кэш с событиями для персонализации.
1) Для холодного старта вычитываются все события из большого хранилища YDB:hotels
2) во время работы обновления событий дочитываются из LB:hotels_wizard чтоб поддерживать актальность и не показывать "спецэффекты".

т.к. в Persister-е подтверждается изначальное сообщение о событии после сохранения в базе, то так же он пишет в LB User Events в то же формате, что и в YDB
Дальше уже на этой очереди стоит Hotel-preprocessor, который раскладывает данные в 2 места: YDB:hotels для старта колдунщика и LB:hotels-wizard для чтения во время работы из колдуна

Идентификация пользователя в отелях проходит по PassportId
Нужно будет добавить в схему БД отдельным полем и начать писать + использовать его для запросов вместо yandexuid

Возможно в будущем потребуется миграция на icookie

## Рубильники:
- отключить персонализацию.
- отключить персонализацию в Отелях.


## Заметки на полях с проектирования

Ручка:
1. Отдает историю поиска
2. Отдает дополнение информации для поиска

Пользовательские кейсы:

Поиск и пресеты с историей поиска человека.

API:
suggest
argument search
history

Тезисы:
- Поиск авиационный должен конвертиться в отельный.
- Если город отеля совпадает с GeoId пользователя - не показывать на авиа такой поиск.
- Авиационный поиск превращается в авиа - дополнением GeoId пользователя, а авиа превращается в отельный отрезанием города вылета.
- Крипта - не предлагать отель при возвращении домой?
- получив заказ в Авиа - перестать пушить поиск???(не отдавать такой контекст фронту вообще/ранжировать ниже того, что можно показать помимо него) Юра за удаление, а Олег со Львом за ранжирование.
- получив заказ в Авиа на Отелях если не было поиска на Отелях - пушим даты заказа Авиа, а если Уточняются даты на Отелях в диапазоне дат Авиа, то учитывать дальше их
- Надо переименовать комод в "Тетрис". Цель проекта как в тетрисе заполнить линию целиком - чтоб пользователь уходил с оформленным заказом в каждой вертикали=)
- если билет авиа туда-обратно, а если только туда, то с дефолтными датами по городам
- Обязательно нужно логировать с фронта на что нажимают и что показывали и провязыывать с другими логами сессии пользователя: проверяем например, сценарии кликают ли на то, что уже покупают

Ранжирование такое:
- заказ в своей вертикали
- поиск в своей вертикали
- заказ в другой вертикали
- поиск в другой вертикали

Для получения поисков отелей - Саша говорит, что есть общий лог и можно отсеять только динамические взаимодействия с колдуном. + туда же вроде как летят и портальные или есть лог тревел-апи, но там скорее всего полуфабрикат.
