---
title: Sandbox Planner
---
# Sandbox Planner

### Что это?

Это инструмент для управления регулярными задачами в Sandbox.

Отличительные особенности:
* Хранение расписания запуска задач в Аркадии
* Единое расписание на разные окружения (prod и testing)
* Простота использования
* Запуск произвольного кода, собирающегося из Аркадии
* Запуск задач по расписанию или по появлению таблицы/папки в YT
* Мониторинг запусков через Solomon
* Шаблонизация описаний задач
* Интеграция с Vault

### Как устроено?

Система состоит из двух частей - универсальный запускатор кода в Sandbox и планировщик.

##### TRAVEL_RUN_BINARY

Это Sandbox-таск [TRAVEL_RUN_BINARY](https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/projects/Travel/tasks/TravelRunBinary/__init__.py),
который позволяет запустить в Sandbox код из любого ресурса в Sandbox.
* Скачивает ресурс по указанному типу, с учетом окружения и того, куда ресурс был Released.
* Запускает бинарный файл из ресурса, и передаёт ему заданные аргументы, с подстановкой секретов через Vault.
* Репортит результаты работы в Solomon

##### Sandbox_planner
Это утилита, которая через Sandbox-API настраивает Sandbox-scheduler-ы на запуск задач в нужное время.
Каждый запуск sandbox_planner приводит к планированию запусков задач на ближайшие 2 часа (конфигурируемо).
Таким образом, для поддержания непрерывного выполнения задач, необходимо запускать sandbox_planner не реже,
чем раз в два часа.

При каждом запуске sandbox_planner анализирует файлы plan/*.yaml, в которых хранится общее расписание запусков,
вычисляет какие задачи нужно запустить в ближайшее время и настраивает Sandbox Scheduler-ы на запуск этих задач в требуемое время.

Оригиналы файлов plan/*.yaml лежат в [Аркадии](https://a.yandex-team.ru/arc/trunk/arcadia/travel/hotels/devops/sandbox_planner/plan).
Автоматика после коммита складывает эти файлы в YT: [прод](https://yt.yandex-team.ru/hahn/navigation?path=//home/travel/prod/general/sandbox/plan)
и [тестинг](https://yt.yandex-team.ru/hahn/navigation?path=//home/travel/testing/general/sandbox/plan).
У плана в YT также выставляется аттрибут `_arcadia_revision`, равный номеру SVN ревизии плана.

При локальных запусках используются файлы из аркадии, при регулярных запусках - план из YT.

### Использование

Для локального запуска секреты берутся из Vault автоматически, токен указывать не нужно.

#### Добавление новой задачи

1. Создать сборочную цель в Аркадии.
2. Создать отдельный ресурс в Sandbox, вписав его [в sandbox](https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/projects/Travel/resources/__init__.py)
3. Настроить автосборку, вписавшись сюда [в testenv](https://a.yandex-team.ru/arc/trunk/arcadia/testenv/jobs/travel/TravelBuild.yaml), после чего добавив новую джобу на выполнение в базе [здесь](https://beta-testenv.yandex-team.ru/project/travel-trunk/jobs)
4. Добавить описание запуска в plan/*.yaml
5. Отладить запуск (через однократный запуск, см. ниже)
6. Применить изменение plan/*.yaml (см. ниже)
7. Запустить `./sandbox_planner prepare-dashboard` для подготовки дашборда в Solomon-е
8. Через Solomon-tool залить обновленный дашборд

#### Однократный запуск задачи

1. Запустить `./sandbox_planner -e <нужное окружение> run-now <plan-id> `
2. Оповещения придут на вашу почту

#### Применение изменения в plan/*.yaml
1. Запустить `./sandbox_planner validate-plan` для проверки плана
2. Закоммитить plan/*.yaml
3. Дождаться автоматической выкладки в тестинг и прод (3-5 минут), оповещения будут в канале [#понябот-build-notifications](https://app.slack.com/client/T1B8NLW31/C7GNHMHJ9)
4. Если что-то идет не так - то стоит посмотреть в [TestEnv-е](https://beta-testenv.yandex-team.ru/project/travel-trunk-sandbox-planner/job/TRAVEL_UPDATE_SANDBOX_PLANNER_PLAN/history?limit=20)
и/или обратиться в канал #sandbox-planner.

#### Мониторинг

Дашборд запусков живёт [тут](https://solomon.yandex-team.ru/?project=travel&cluster=push_prod&service=sandbox&dashboard=travel-sandbox&b=1d&e=).
Письма о падениях приходят на [travel-sandbox-prod@](https://ml.yandex-team.ru/lists/travel-sandbox-prod/) и
[travel-sandbox-testing@](https://ml.yandex-team.ru/lists/travel-sandbox-testing/)

### Формат файла plan/*.yaml

Файл организован в виде словаря, где ключом является plan_id, а значением - plan_item.

plan_id - это уникальный идентификатор задачи, plan_item - её описание.

Есть несколько служебных plan-id, которые начинаются с подчеркивания:

* `_vars` - общие переменные
* `_vars_testing` - переменные для testing-а
* `_vars_prod` - переменные для prod-а.

Переменные подставляются в plan_item. Формат подстановки - Jinja2, т.е. `{{var_name}}`.
Любопытно, что plan_id тоже шаблонизируется, при этом ожидается, что значением переменной будет список.
Это используется для порождения похожих задач - один шаблонизируемый plan_item раскрывается в несколько.

Поля Plan_item

| Название           | тип  | default           | Описание |
| ------------------ | ---- | ----------------- | --------------------------------------------------- |
| `description`            | str  |                   | Описание задачи, на работу не влияет                |
| `tags`                   | list |                   | Список кастомных тэгов для удобного поиска задач в SB |
| `resource`               | str  |                   | Тип ресурса для запуска. **Обязательное поле**      |
| `command`                | str  |                   | Команда для запуска. Не обязательна для ресурсов, собранных через YA_MAKE |
| `args`                   | str  |                   | Аргументы для запуска                               |
| `cron`                   | str  |                   | Cron-выражение для запуска по расписанию            |
| `yt_trigger`             | описан ниже  |                   | Кластер и путь YT для запуска по изменению папки/табпицы |
| `kill_timeout`           | int  | 10800             | Максимальное время исполнения, в секундах           |
| `enabled`                | bool | true              | Если false, то задача отключена и не исполняется    |
| `semaphore_name`         | str  | {plan_id}.{env}   | Имя семафора для ограничения количества одновременно выполняющихся задач |
| `concurrency`            | int  | 1                 | Максимальное количество одновременно исполняющихся задач с данным semaphore_name |
| `do_extract`             | bool | false             | Нужно ли распаковывать ресурс (актуально для ресурсов, собранных через YA_PACKAGE) |
| `task_type`              | str  | TRAVEL_RUN_BINARY | Тип исполняющей задачи. *Для отладки*               |
| `output_resources_file`  | str  |                   | Имя файла со списком выходных ресурсов |
| `notify_email`           | str  | `travel-sandbox-{env}` | Куда слать оповещения о падениях  |
| `container_resource`     | int  |                   | Ресурс типа LXC_CONTAINER из которого надо взять контейнер для запуска этой задачи. Такой ресурс собирается задачей SANDBOX_LXC_IMAGE.  |
| `requires_dns64`         | bool | false             | Задаче требуется поддержка DNS64 для доступа в инернет |

Для каждого поля XX также используется уточняющее поле XX_testing или XX_prod в зависимости от окружения (e.g. `enabled_prod: false` отключит исполнение задачи в проде).
Для всех полей, кроме `args` берется значение уточняющего поля, если указано, т.е. уточняющие поля имеют приоритет.
Для `args` значение основного и уточняющего поля склеивается через пробел.

### Запуск по появлению/изменению YT-таблицы

Для активации этого режима нужно указать поле `yt_trigger`.

Поле содержит список структур вида:

```yaml
yt_trigger:
    - path: cluster1.path1[/*]
      max_age: 1d
    - path: cluster2.path2[/*]
      creation_date_from: 2020-01-01
    - path: cluster3.path3[/*]
```

Для простоты, если max_age не задан, можно использовать сокращенную запись, состоящую только из пути:
```yaml
yt_trigger:
    - path: cluster1.path1[/*]
      max_age: 1d
    - cluster2.path2[/*]
    - cluster3.path3[/*]
```

Если элемент в списке один, то можно указать сразу его, без списка:
```yaml
yt_trigger: cluster1.path1[/*]
```


Поле `path`:
* Формат поля: `cluster.path[/*]`
* Если `path` оканчивается на `/*`, то считается что путь - это папка. Производится отслеживанеи её содержимого (через list),
и при появлении новой подтаблицы/подпапки, а так же при изменении существующих (по `content_revision`), производится запуск задачи.
При этом в аргументы задачи необходимо передать путь до появившейся/изменившейся папки/таблицы, указав спец-подстановку `%YT_TRIGGER_PATH%`.
* Иначе (если `path` не оканчивается на `/*`), то считается что путь - произвольный узел Кипариса.
Задача будет запущена при любом изменении указанного узла (отслеживается аттрибут `content_revision`).

Поле `min_age`/`max_age`:
* Задаёт минимальный (максимальный) возраст таблицы (по атрибуту `creation_time`) для запуска триггера.
* Работает только при использовании триггера по директории (оканчивающегося на `/*`).

Поле `creation_date_from`:
* Задаёт минимальное значение времени создания таблицы (по атрибуту `creation_time`) для запуска триггера.
* Работает только при использовании триггера по директории (оканчивающегося на `/*`).
* Задаётся формате iso (`YYYY-MM-DD[*HH[:MM[:SS[.mmm[mmm]]]][+HH:MM[:SS[.ffffff]]]]`) в utc.

Поле `table_name_exclude_pattern`:
* Таблицы, имя которых соответствует этому шаблону, будут пропущены.
* Работает только при использовании триггера по директории (оканчивающегося на `/*`).
* Задаётся формате регулярного выражения.

Поле `ignore_modifications`:
* Триггер будет срабатывать только при появлении новых таблиц, но не при их изменении.
* Работает только при использовании триггера по директории (оканчивающегося на `/*`).


### Создание ресурсов

Задача может сгенерировать ресурсы. Для этого необходимо:
1. Указать параметр `output_resources_file`
2. В коде исполнения задачи сгенерировать файл с этим именем (в current working dir).
Формат файла:
```
resources:
  - type: TRAVEL_DUMMY_SERVICE_PACKAGE
    description: "example"
    path: resource_data.txt
    attrs:
      ttl: 21
```
TRAVEL_RUN_BINARY после исполнения кода задачи прочитает этот файл, и прикрепит все указанные в нём файлы как ресурсы.

Если необходимо сразу после выполнения задачи релизнуть сгенерированные ею ресурсы, то в сгенерированный файл можно добавить для этого отдельную секцию:
```
release:
  env: stable
  title: Release title
  comments: release comments
```

Релиз будет выполнен в Няню и в Деплой, с типом релиза соответствующем заданному в поле `env`.


### Работа с секретами

Все секреты хранятся в [Vault](yav.yandex-team.ru).

Для того, чтобы секрет стал доступен планировщику, он должен быть доступен на чтение роботу `robot-travel-prod` для окружения `prod`
или роботу `robot-travel-test` для окружения `testing`.

Перед использованием секрета он должен быть делегирован в sandbox, это происходит автоматически при запуске команды `update-plan`

Секреты указываются в таком формате: `sec-XXXX[.key-YYYY][.ver-ZZZZ]`.

Вот как секрет попадает в исполняемый код:
* TRAVEL_RUN_BINARY парсит аргументы, и все, что начинается на `sec-` считается секретом
* TRAVEL_RUN_BINARY получает значения секретов из Vault
* TRAVEL_RUN_BINARY складывает секреты в переменную окружения `ARG_REPLACES`
* Исполняемый код из ресурса получает аргументы без замены, и перменную `ARG_REPLACES`
* Для корректной работы нужно заменить секретные аргументы
  * Python. Это делается вызовом специальной
    [функции](https://a.yandex-team.ru/arc/trunk/arcadia/travel/library/python/tools/__init__.py?rev=6473669#L36).
    Вот [пример](https://a.yandex-team.ru/arc/trunk/arcadia/travel/hotels/devops/sandbox_planner/__main__.py?rev=6672071#L587)
  * Go. [Функция](https://a.yandex-team.ru/arc/trunk/arcadia/travel/library/go/sandbox_planner/args.go?rev=r7788430#L34)
    и [пример](https://a.yandex-team.ru/arc/trunk/arcadia/travel/tools/sandbox_to_s3_dicts_dumper/main.go?rev=r7788430#L56)

Такие сложности с `ARG_REPLACES` нужны для того, чтобы секреты нигде не залоггировались.

### Получение ресурсов на вход задачи

Если нужно при выполнении задачи воспользоваться каким-нибудь ресурсом из Sandbox, то его можно получить очень простым образом,
написав в аргументах `--argument resource-RESOURCE_TYPE`. В этом случае TRAVEL_RUN_BINARY автоматически скачает указанный ресурс
(последний из доступных), и подставит путь до него в аргумент вместо `resource-RESOURCE_TYPE`.
[Пример.](https://a.yandex-team.ru/arc/trunk/arcadia/travel/hotels/devops/sandbox_planner/plan.yaml?rev=7222609#L486)

Если требуется получить зарелиженный  ресурс, то для этого нужно написать `resource-RESOURCE_TYPE.released_at=stable` или
 `resource-RESOURCE_TYPE.released_at=testing`.



### Различные рецепты

#### Регулярный запуск YQL запроса

Если YQL запрос не требует дополнительной обвязки, то его запуск рекомендуется делать через [вот эту обёртку](https://a.yandex-team.ru/arc/trunk/arcadia/travel/hotels/tools/run_yql).

#### Сетевые доступы (дырки)

Если из задачи нужно сходить в какой-то сервис, то дырку нужно заказывать из сети `_CMSEARCHNETS_`.
Ссылка на [Документацию Sandbox](https://wiki.yandex-team.ru/sandbox/FAQ/#firewall-macro)
