---
title: Компоненты
rank: 20
---
### Компоненты

Notifier реализовано как монолитное Go приложение. И состоит из следующих компонент:

#### API

Тонкий слой, ответственный за интеграцию с внешними системами.
Предоставляет говорящие методы для различных сценариев использования.

##### OrderChangesService

| Метод | Описание |
|-------|---------|
| [`OrderChanged`](https://a.yandex-team.ru/arc/trunk/arcadia/travel/notifier/api/order/v1/order_changes_service.proto?rev=7643582#L18)| Метод для уведомления о создании/изменении заказа |

#### Процессинг

Для различных сценариев уведомлений реализуются отдельные модули, соответствующие разным типам писем и реализующие необходимую для них бизнес логику.
Эти модули превращают сигналы от API, от планировщика в новые сигналы для планировщика или уже в конкретные письма для конкретных людей, готовые к отправке Отправщиком. 
Например, для транзакционных писем - это тонкая логика, прокидывающая вызов as-is в Отправщик. 
Для PreTrip это дедупликация заказов, а так же планирование уведомлений на -K и -N дней до отправки. 
Если Процессингу нужно запланировать какую то отложенную отправку - он регистирует ее в Планировщике и ждет, пока Планировщик вызовет его обратно в нужный момент. 
Когда необходимо отправить уведомление - Процессинг вызывает Отправщик. Если Отправщик не может осуществить отправку - Процессинг обрабатывает результирующую ошибку и принимает решение что делать дальше (ничего / перепланировать). 
Процессинг обладает состоянием. Он отслеживает состояние Уведомлений (чтобы обеспечить гарантированную отправку), компоненты Процессинга могут обладать своим состоянием, например PreTrip знает о том - включен он или нет, маркетинговые рассылки - списки пользователей которым их можно отправить. 

#### Планировщик

Задача - запланировать отложенную отправку. По факту регистрирует некий колбэк, который потом вызывает у Процессинга, чтобы отправить Уведомление.
Обладает состоянием - список запланированных отложенных отправок.

#### Отправщик

Задача - собрать данные для отправки уведомления, передать их в Renderer, полученную html передать в sender.
Не обладает состоянием.