---
title: Общее описание
rank: 100
---

### Общее описание

Оркестратор - сервис создания и управления заказами.

Основные сущности с которыми работает оркестратор:
- Заказ (`Order` и его наследники `HotelOrder`, `TrainOrder`, `GenericOrder`)
- Услуга (`OrderItem` и его наследниики `TrainOrderItem`, `HotelOrderItem`, и т.д.)
- Инвойс (основание для приема денег, сейчас очень тесно соотносится с Корзиной в TRUST-е)

С точки зрения оркестратора заказ - это набор услуг, оказываемых пользователю. Задача оркестратора координировать жизненный цикл заказа, услуг, входящих в заказ и платежей, принимаемых (возвращаемых) от пользователя(ю).

Используя библиотеку примитивов описания процессов workflow оркестратор описывает набор сущностей, транзакционно меняющих свое состояние, одновременно оповещая workflow соседних сущностей об этом.

### Техническое

Оркестратор представляет из себе standalone java Spring Boot приложение, взаимодействующее с базой данных (postgresql). Приложение оркестратора можно поделить на две крупные части:
1. GRPC сервисы для взаимодействия с внешним миром
2. Workflow handler-ы, зарегистрированные для работы с workflow сущностей оркестратора и TaskProcessor-ы, обрабатывающие фоновые задачи, связанные с сущностями.

GRPC сервисы, workflow handler-ы и taskProcessor-ы используют для своей работы сущности (entities), сервисы (services), содержащие функционал и бизнес-логику и repository - вспомогательные сервисы для получения сущностей из базы данных.

Используемые библиотеки:
- Spring Boot
- Spring Data Jpa
- Hibernate
- Jackson

#### Основные GRPC сервисы

- [OrdersService](https://a.yandex-team.ru/arc_vcs/travel/orders/app/src/main/java/ru/yandex/travel/orders/grpc/OrdersService.java) - основной сервис взаимодействия с заказом с точки зрения пользователя. Содержит методы создания заказа, начала оплаты, получения информации о заказе и работы с возвратом

- [OrdersAdminService](https://a.yandex-team.ru/arc_vcs/travel/orders/app/src/main/java/ru/yandex/travel/orders/grpc/OrdersAdminService.java) - сервис по работе с заказов из Админки заказов

- [OrdersNoAuthService](https://a.yandex-team.ru/arc_vcs/travel/orders/app/src/main/java/ru/yandex/travel/orders/grpc/OrdersNoAuthService.java) - сервис получения информации о заказе без проверки привязки к пользователю (ваучерница, коллбэки траста)

### Важные ограничения

#### Совместимость с самим собой

Если вы добавляете изменяете структуры данных, которые сохраняются в БД, то надо помнить о том, что выкатка оркестратора не происходит одномоментно.
Будет промежуток времени, когда на части нод работает старая версия кода, а на части - уже новая.
Чтобы избежать проблем, стоит изменять такие структуры данных двухфазно:
1. Добавить новое поле в структуру/enum, научиться его обрабатывать, но пока нигде не заполнять.
2. Выкатить. После выкатки все ноды оркестратора готовы обрабатывать сообщения с новыми полями.
3. Начать заполнять поле.
4. Выкатить.

Это можно реализовать также через feature toggle.

#### Совместимость с Travel API

При изменении протокола Travel API <-> Оркестратор также важно помнить об обратной совместимости.
Есть два алгоритма действий: надёжный и быстрый.

Надёжный алгоритм заключается в двухфазной выкатке:
1. сначала добавить в протокол поле, научиться его обрабатывать, но не заполнять
2. выкатить Travel API и Orders
3. Начать заполнять поле.
4. Выкатить Travel API и/или Orders.

Быстрый алгоритм - для уверенных в себе людей.
Перед началом важно понять, что надо выкатить раньше - Travel API или Оркестратор.
В некоторых ситуациях данный подход может быть неприменим - если невозможно определить, с какого сервиса начать.
Алгоритм такой:
1. Вносим изменения
2. Выкатываем в prod сервис, который только потребляет новые поля. Важно выкатить его раньше, чем сервис, который эти поля производит
3. Выкатываем в prod сервис, который производит новые поля.

Риск данного подхода в том, что можно не успеть сделать п.2, так что дважды подумайте, нужен ли вам этот риск.



