---
title: Миграции базы данных
rank: 200
---

# Механизм накатывания миграций

Для накатывания миграций используется Flyway
Миграции версионируются в порядке возрастания. Имена файлов имеют вид `V1, V2, ... V<version_number>`. В общем случае version_number это целое число. Но возможно использовать вариант версионирования `V4.1, V4.2, V4.3`. Такой порядок нумерования используется для накатывания фиксов и миграций на прод окружение, чтобы потом их без проблем смержить обратно в транк.
Общие соображения:
* миграции должны быть по возможности быстрыми
* удаление полей в колонках надо планировать заранее, совместно с релизами приложения (сперва создается миграция с добавлением нового поля, потом выкладывается приложение, которое умеет работать с новым полем и со старым, происходит миграция старых данных в новое поле, выкатывается версия приложения, которое использует только новое поле, только после этого возможна миграция, удаляющая поле).

## Тестинг
В тестинге миграции накатываются автоматом, и для них включена опция накатывания миграций out_of_order, это означает, что при мерже хотфиксов вида `V4.1, V4.2, V4.3` в транк и выкатке на тестинг, такие миграции будут накачены, даже если уже выкачены в тестинг миграции `V5, V6` (следующие по порядку).

## Прод

Для прод окружения миграции необходимо накатывать руками.

Для этого надо использовать [db_migrator](https://a.yandex-team.ru/arc/trunk/arcadia/travel/orders/tools/db_migrator).

### Первичная настройка
В миграторе включена обязательная проверка сертификатов. Нужно скачать внутренний сертификат к себе:
```bash
mkdir -p ~/.postgresql && \
curl "https://crls.yandex.net/allCAs.pem" > ~/.postgresql/root.crt && \
chmod 0600 ~/.postgresql/root.crt
```

### Перед каждой миграцией

В корне аркадии:
```bash
ya make travel/orders/tools/db_migrator
cd travel/orders/tools/db_migrator && ya package --raw-package package.json
```

{% note alert %}

Необходимо собирать инструмент db_migrator из релизной ветки (важно понимать, что в него приезжают миграции из текущей рабочей копии svn, поэтому если ваша рабочая копия смотрит на транк, то вы накатите миграции из транка)
Возможно будет полезен вот этот ответ [Как счекаутить заданную ревизию svn в ARC](https://wiki.yandex-team.ru/arcadia/arc/faq/#kakschekautitzadannujurevizijusvn)

{% endnote %}


Получится директория вида `db-migrator.<revision_number>`. Получаем доступ к [секрету](https://yav.yandex-team.ru/secret/sec-01datq0myrd0zv6bfzfgvgbf8x/create/version/ver-01datq0mz15fzbr8nc8w3ewnyh).



```bash
# проверяем состояние миграций:
db-migrator.<revision_version>/db_migrator/bin/flyway.py -X -password=`ya vault get version -o value ver-01ehsgj1rvtcmdmdgm8txxvqg4` info
# накатывает текущие миграции
db-migrator.<revision_version>/db_migrator/bin/flyway.py -X -password=`ya vault get version -o value ver-01ehsgj1rvtcmdmdgm8txxvqg4` migrate
```

## Хотфиксы

- Построение индексов при необходимости оптимизаций и невозможности откладывать до следующего релиза.
- Изменения в структуре данных, которые необходимо совершить до следующего релиза

При необходимости внести хотфиксы в базу в проде, сперва делается переключение в текущую релизную ветку, после этого добавить новые миграции в `travel/orders/app/src/resources/db/migration`. 

{% note warning %}

Миграции надо добавлять с минорной версией. То есть если на проде текущая последняя версия `V78`, то hotfix должны быть вида `V78.1, V78.2` и т.д. Это делается для того, чтобы их можно было без проблем вмержить потом в транк.!!

{% endnote %}
