---
title: Органический классификатор 1Орг/мнОрг
---

## Органический классификатор 1Орг/мнОрг

### Что это и зачем

В правиле переранжирования [org_wizard]([https://a.yandex-team.ru/arc/trunk/arcadia/search/web/rearrange/org_wizard/org_wizard.cpp) 
происходит выбор какой из колдунщиков организаций показать:
* 1Орг ванильный (не отельный)
* мнОрг ванильный (не отельный)
* 1Орг отельный 
* мнОрг отельный

Какой тип колдуна показывать - ванильный или отельный - выбирается на основании наличия отельных провязок: 
* для 1орг: если у первой организации есть провязки - покажем отельный 1орг
* для мнОрг: если у 3 из 5 первых органиаций есть провязки - покажем отельный мнОрг.

Выбор между 1орг и мнОрг делается с помощью сложной эвристики [QueryType](https://a.yandex-team.ru/arc/trunk/arcadia/search/web/rearrange/org_wizard/org_wizard.cpp?rev=r7740370#L1752).
Для отелей эта эвристика часто оказывается не очень точна.

Была предложена другая эвристика: смотреть в органическую выдачу на урлы конкурентов, и решать, на что они больше похожи: на 1орг или мнОрг.
Эта эвристика и называется "Органический классификатор".

Работа веласть в рамках тикета [TRAVELWIZ-93](https://st.yandex-team.ru/TRAVELWIZ-93) 

### Особенности реализации

* Смотрим на урлы следующих конкурентов: `Booking`, `Ostrovok`, `Hotels.ru`, `TripAdvisor`, `101Hotels`, `TopHotels`.
* Если по урлам не удалось определить тип выдачи (1орг/мнОрг), возвращаемся к старой эвристике

### Достоинства подхода

* Опираемся на органику, качество которой считаем довольно высоким
* Уменьшаем вероятность "странных" серпов, где сочетается 1орг органика и мнОрг колдун (или наоборот)
* По оффлайн метрикам получаем рост полноты срабатывания на отельной 1орг корзинке с 84.6% до 89.7% при теоретическом пределе 90.4% (лимитируется отельными провязками) (числа без учета блендерного бана).

### Недостатки

* Классификация опирается на урлы конкуретнов, которые могут меняться со временем. Будем отслеживать и подстраиваться, тикет [TRAVELANALYTICS-596](https://st.yandex-team.ru/TRAVELANALYTICS-596). 
* Для мнОрг корзинки имеем падение полноты с 82.1% до 81% при теоретическом пределе 82.8%. Падение объясняется тем, что мы стали показывать отельный 1орг вместо мнОрг по многим сомнительным запросам.

### Исходники

* Анализ органики запускается [тут](https://a.yandex-team.ru/arc/trunk/arcadia/search/web/rearrange/org_wizard/org_wizard.cpp?rev=r7740370#L1457)
* Разбор урлов находится [тут](https://a.yandex-team.ru/arc/trunk/arcadia/search/web/rearrange/org_wizard/travel_organic_classifier.cpp?rev=r7740370#L183)
* Результаты применяются [тут](https://a.yandex-team.ru/arc/trunk/arcadia/search/web/rearrange/org_wizard/org_wizard.cpp?rev=r7740370#L1741)
