package ru.yandex.travel.externalapi.configuration;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.web.context.request.WebRequest;

public class CustomErrorAttributes extends DefaultErrorAttributes {

    @Override
    public Map<String, Object> getErrorAttributes(WebRequest webRequest, boolean includeStackTrace) {
        Map<String, Object> original = super.getErrorAttributes(webRequest, includeStackTrace);
        Map<String, Object> errorAttributes = new LinkedHashMap<>();
        putIfPresent(original, errorAttributes, Set.of("status", "error"));
        return errorAttributes;
    }

    private void putIfPresent(Map<String, Object> src, Map<String, Object> dst, Set<String> keys) {
        for (String key : keys) {
            if (src.containsKey(key)) {
                dst.put(key, src.get(key));
            }
        }
    }
}
