package ru.yandex.travel.externalapi.configuration;

import java.time.ZoneOffset;

import javax.validation.constraints.NotNull;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value = "external-api", ignoreUnknownFields = false)
@Validated
@Getter
@Setter
public class ExternalApiProperties {
    private String portalHotelUrlTemplate;

    @NotNull
    private ZoneOffset defaultZoneOffset;

}
