package ru.yandex.travel.externalapi.configuration;

import java.time.Duration;
import java.util.List;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.orders.client.FailureDetectorProperties;
import ru.yandex.travel.orders.client.GrpcChannelSupplierMode;
import ru.yandex.travel.orders.client.GrpcChannelSupplierProperties;
import ru.yandex.travel.orders.client.yp.YpDiscoveryProperties;

@ConfigurationProperties(value = "hotels-administrator", ignoreUnknownFields = false)
@Validated
@Getter
@Setter
public class HotelsAdministratorConfigurationProperties implements GrpcChannelSupplierProperties {
    private List<String> targets;

    @Valid
    private YpDiscoveryProperties yp;

    @Valid
    @NotNull
    private GrpcChannelSupplierMode mode;

    @NotNull
    private Duration timeout;

    @Valid
    private FailureDetectorProperties failureDetection;

    private Tvm tvm;

    @Positive
    private int maxMessageSize;

    @Getter
    @Setter
    @Validated
    public static class Tvm {
        private boolean enabled;
        @NotEmpty
        private String destinationAlias;
    }

}
