package ru.yandex.travel.externalapi.configuration;

import java.util.List;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.opentracing.Tracer;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.servlet.DispatcherServletAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import ru.yandex.travel.http.ReqAnsLoggerInterceptor;
import ru.yandex.travel.http.ReqAnsLoggingDispatcherServlet;

@Configuration
@RequiredArgsConstructor
@Slf4j
@ConditionalOnProperty(value = "logging.reqans.enabled", havingValue = "true")
public class ReqAnsLoggingConfiguration implements WebMvcConfigurer {
    private final ObjectMapper objectMapper;
    private final Tracer tracer;

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(new ReqAnsLoggerInterceptor(objectMapper, tracer, List.of("Authorization")))
                .addPathPatterns("/travelline/**")
                .addPathPatterns("/bnovo/**")
                .addPathPatterns("/admitad/**")
                .addPathPatterns("/travelpayouts/**")
                .addPathPatterns("/google_hotels/**")
                .order(Integer.MIN_VALUE);
    }

    @Primary
    @Bean(name = DispatcherServletAutoConfiguration.DEFAULT_DISPATCHER_SERVLET_BEAN_NAME)
    public DispatcherServlet dispatcherServlet(WebMvcProperties webMvcProperties) {
        DispatcherServlet dispatcherServlet = new ReqAnsLoggingDispatcherServlet();
        dispatcherServlet.setDispatchOptionsRequest(
                webMvcProperties.isDispatchOptionsRequest());
        dispatcherServlet.setDispatchTraceRequest(
                webMvcProperties.isDispatchTraceRequest());
        dispatcherServlet.setThrowExceptionIfNoHandlerFound(
                webMvcProperties.isThrowExceptionIfNoHandlerFound());
        return dispatcherServlet;
    }
}
